/* skinning for skeletal animation.
 */
 
 
#pragma define MAX_BONES


in float vsInNumGrps;
// number of elements (4) should match engine code constant
in vec4 vsInGrpIdxs;
in vec4 vsInGrpWeights;

uniform mat4 uSkinMats[MAX_BONES];


// 4th element should be 1 for positions and 0 for normals.
vec4 skin( in vec4 vec )
{
	vec4 rslt = vec4( 0.0 );
	
	for (int i = 0; i < int(vsInNumGrps); i++)
	{
		int matIdx = int(vsInGrpIdxs[i]);
		rslt += (uSkinMats[matIdx] * vec) * vsInGrpWeights[i];
	}
	
	return rslt;
}