/* pokemon character.
 */


uniform sampler2D uTexDif;
uniform sampler2D uTexSpc;


in vec3 fsInCPos;
in vec4 fsInColor;
in vec3 fsInNrm;

out vec4 fsOut0;
out vec4 fsOut1;


#pragma include pkmn_lights.glsl


void main(void)
{
	vec3 nrm = normalize( fsInNrm );
	
	vec3 lightSpec = vec3(0.0);
	vec3 toCam = normalize( -fsInCPos );
	fsOut0.rgb = fsInColor.rgb * celShade_Pkmn( toCam, nrm, lightSpec );
	
	float spc = texture( uTexSpc, fsInUV ).r;
	fsOut0.rgb += spc * lightSpec;

	// from [-1,1] to [0,1]
	fsOut1.rgb = (nrm + vec3(1.0)) * 0.5;
	fsOut1.a = 1.0;
}