/* pokemon character.
 */


uniform sampler2D uTexDif;
uniform sampler2D uTexSpc;
uniform vec4 uRGBA;


in vec3 fsInCPos;
in vec3 fsInNrm;
in vec2 fsInUV;
in vec4 fsInColor;

out vec4 fsOut0;
out vec4 fsOut1;


#pragma include pkmn_lights.glsl


void main(void)
{
	vec3 nrm = normalize( fsInNrm );

	fsOut0 = texture(uTexDif, fsInUV) * fsInColor;

	vec3 lightSpec = vec3(0.0);
	vec3 toCam = normalize( -fsInCPos );
	fsOut0.rgb *= celShade_Pkmn( toCam, nrm, lightSpec );
	fsOut0 *= uRGBA;
	
	float spc = texture( uTexSpc, fsInUV ).r;
	fsOut0.rgb += spc * lightSpec;

	// from [-1,1] to [0,1]
	fsOut1.rgb = (nrm + vec3(1.0)) * 0.5;
	fsOut1.a = 1.0;
}