#pragma include lights.glsl


void dirLightDiffuse_Pkmn
	(	in int li, in vec3 nrm,
		inout vec3 diffuse )
{
	float lambert = dot( nrm, uLightVec[li].xyz );
	// from [-1,1] to [0,1]
	lambert = lambert * 0.5 + 0.5;
	
	diffuse += vec3( lambert * uLightColor[li] );
}


void dirLight_Pkmn
	(	in int li, in vec3 toCam, in vec3 nrm,
		inout vec3 diffuse, inout vec3 specular )
{
	dirLightDiffuse_Pkmn( li, nrm, diffuse );
	lightSpec( uLightColor[li], toCam, nrm, uLightVec[li].xyz, specular );
}


void light_Pkmn
	(	in vec3 toCam, in vec3 nrm,
		inout vec3 diffuse, inout vec3 specular )
{
	for( int li = 0; li < int(uNumLights); li++ )
		dirLight_Pkmn( li, toCam, nrm, diffuse, specular );
}


float celShade_Pkmn( in vec3 toCam, in vec3 nrm, inout vec3 lightSpec )
{
	vec3 lightDiff = vec3(0.0);
	light_Pkmn( toCam, nrm, lightDiff, lightSpec );

	// cel shading
	float diffIntensity = max( lightDiff.r, max(lightDiff.g, lightDiff.b) );
	float celDiff = 0.6;
	// fade from dark shadow to light shadow
	celDiff += 0.2 * clamp(diffIntensity - 0.4, 0.0, 0.09) / 0.09;
	// from light shadow to 1
	celDiff += 0.2 * clamp(diffIntensity - 0.6, 0.0, 0.09) / 0.09;
	// from 1 to highlight
	celDiff += 0.4 * clamp(diffIntensity - 0.9, 0.0, 0.09) / 0.09;
	
	return celDiff;
}