uniform vec4 uRGBA;


in vec3 fsInCPos;
in vec4 fsInColor;
in vec3 fsInNrm;

out vec4 fsOut0;


#pragma include pkmn.glsl
#pragma include pkmn_lights.glsl


void main(void)
{
	vec3 nrm = normalize( fsInNrm );
	
	fsOut0 = fsInColor * uRGBA;

	// lighting
	vec3 toCam = normalize( -fsInCPos );
	vec3 lDif = vec3( 0.0 );
	vec3 lSpc = vec3( 0.0 );
	light_Pkmn( toCam, nrm, lDif, lSpc );

	// more transparent near the center (facing the cam)
	float facing = max( 0.0, dot( toCam, nrm ) );
	float edge = 1.0 - facing;
	edge = pow( edge, 2.5 );
	float middle = facing;
	float alpha = min(middle + edge, 1.0);
	
	// increase alpha where specular highlights are.
	alpha = max( alpha, dot( lSpc, vec3(1.0/3.0) ) );
	
	fsOut0 = fsOut0 * alpha;
	
	fsOut0.rgb += lSpc;
}