/* vertex normals. single uv channel.
 */


#pragma include skinning.glsl


uniform mat4 uModelViewMat;
uniform mat4 uModelViewProjMat;


in vec3 vsInPos;
in vec3 vsInNrm;
in vec4 vsInColor;

out vec3 fsInNrm;
out vec4 fsInColor;


void main(void)
{
	vec4 skinned = skin( vec4(vsInPos, 1.0) );
	gl_Position = uModelViewProjMat * skinned;
	
	skinned = skin( vec4(vsInNrm, 0.0) );
	fsInNrm = normalize( (uModelViewMat * skinned).xyz );
	
	fsInColor = vsInColor;
}