// sample from a tangent-space normal map
vec3 nrmMapSample( in sampler2D tex, in vec2 uv )
{
	vec3 t = normalize( fsInTangent );
	vec3 b = normalize( fsInBinrm );
	vec3 n = normalize( fsInNrm );
	mat3 tbn = mat3( t, b, n );
	
	vec3 nrm = texture( tex, uv ).xyz;
	// from [0,1] to [-1,1]
	nrm = nrm * 2.0 - 1.0;
	
	// tangent space to tbn's space
	return tbn * nrm;
}