vec3 tonemapReinhard( in vec3 clr )
{
	return clr / (clr + vec3(1.0));
}


vec3 tonemapFilmicF( in vec3 clr )
{
	float a = 0.22;
	float b = 0.3;
	float c = 0.1;
	float d = 0.2;
	float e = 0.01;
	float f = 0.3;
	
	return ( (clr*(a*clr + c*b) + d*e) / (clr*(a*clr + b) + d*f) ) - e/f;
}

vec3 tonemapFilmic( in vec3 clr, in float exposure, in float white )
{
	return tonemapFilmicF( exposure * clr ) / tonemapFilmicF( vec3(white) );
}