// separated 7x7 Gaussian blur.
// horizontal or vertical pass depending on delta.
// https://software.intel.com/en-us/blogs/2014/07/15/an-investigation-of-fast-real-time-gpu-based-image-blur-algorithms
vec3 gaussBlurFiltered7( in sampler2D tex, in vec2 uv, in vec2 uvDelta )
{
	float gaussFilteredWeights7[2] =
		float[]( 0.44908, 0.05092 );
	float gaussFilteredOffsets7[2] =
		float[]( 0.53805, 2.06278 );
	vec3 outClr = vec3( 0.0 );
	
	for( int i = 0; i < 2; i++ )
	{
		vec2 offset = uvDelta * gaussFilteredOffsets7[i];
		vec3 clr = texture( tex, uv + offset ).rgb;
		clr += texture( tex, uv - offset ).rgb;
		outClr += clr * gaussFilteredWeights7[i];
	}
	
	return outClr;
}