/* gamma correction.
 */


float lRGB_to_sRGB( in float l )
{
	float s;
	if( l <= 0.0031308 )
		s = l * 12.92;
	else
		s = 1.055 * pow( l, 1.0/2.4 ) - 0.055;

	return s;
}

vec3 lRGB_to_sRGB( in vec3 l )
{
	vec3 s;
	s.r = lRGB_to_sRGB( l.r );
	s.g = lRGB_to_sRGB( l.g );
	s.b = lRGB_to_sRGB( l.b );
	return s;
}