#pragma include fog_frag.glsl

// linear fog params
// x = min depth (clip space)
// y = max depth (clip space)
// z = fog factor multiplier [0,1] (fog factor at max depth)
uniform vec3 uFogParamsLin;


void mixFog_linear( inout vec3 clr, in float depth, in float cwInv )
{
	depth = fogWindowToClipDepth( depth, cwInv );
	
	float fogFactor = (depth - uFogParamsLin.x) / (uFogParamsLin.y - uFogParamsLin.x);
	fogFactor = clamp( fogFactor, 0.0, 1.0 ) * uFogParamsLin.z;
	
	clr = mix( clr, uFogColor, fogFactor );
}