#pragma include fog_frag.glsl

// exponential fog params
// x = density
// y = power
// z = fog factor multiplier [0,1]
uniform vec3 uFogParamsExp;


void mixFog_exp( inout vec3 clr, in float depth, in float cwInv )
{
	depth = fogWindowToClipDepth( depth, cwInv );
	
	float p = pow(uFogParamsExp.x * depth, uFogParamsExp.y);
	p = max( p, 0.001 );
	float fogFactor = exp( -p );
	fogFactor = (1.0 - clamp( fogFactor, 0.0, 1.0 )) * uFogParamsExp.z;
	
	clr = mix( clr, uFogColor, fogFactor );
}