#pragma include skinning.glsl


uniform mat4 uModelViewMat;
uniform mat4 uModelViewProjMat;


in vec3 vsInPos;
in vec4 vsInColor;
in vec3 vsInNrm;

out vec3 fsInCPos;
out vec3 fsInNrm;
out vec4 fsInColor;


void main(void)
{
	vec4 skinned = skin( vec4(vsInPos, 1.0) );
	gl_Position = uModelViewProjMat * skinned;
	
	// position in camera space
	fsInCPos = (uModelViewMat * skinned).xyz;
	
	fsInColor = vsInColor;
	
	skinned = skin( vec4(vsInNrm, 0.0) );
	fsInNrm = normalize( (uModelViewMat * skinned).xyz );
}