uniform mat4 uModelViewMat;
uniform mat4 uModelViewProjMat;


in vec3 vsInPos;
in vec4 vsInColor;
in vec3 vsInNrm;

out vec3 fsInCPos;
out vec3 fsInNrm;
out vec4 fsInColor;


void main(void)
{
	gl_Position = uModelViewProjMat * vec4(vsInPos, 1.0);
	
	// position in camera space
	fsInCPos = (uModelViewMat * vec4(vsInPos, 1.0)).xyz;
	
	fsInColor = vsInColor;
	fsInNrm = normalize( vec3(uModelViewMat * vec4(vsInNrm, 0.0)) );
}