/* vertex normals. single uv channel.
 */

uniform mat4 uModelViewMat;
uniform mat4 uModelViewProjMat;


in vec3 vsInPos;
in vec2 vsInUV;
in vec3 vsInNrm;

out vec3 fsInCPos;
out vec3 fsInNrm;
out vec2 fsInUV;


void main(void)
{
	gl_Position = uModelViewProjMat * vec4(vsInPos, 1.0);

	// position in camera space
	fsInCPos = (uModelViewMat * vec4(vsInPos, 1.0)).xyz;
	
	fsInNrm = normalize( vec3(uModelViewMat * vec4(vsInNrm, 0.0)) );
	
	fsInUV = vsInUV;
}