#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform vec4 u_tint;

void main() {
    vec4 clr = texture2D(u_texture, v_texCoords);

    vec4 tint = u_tint;

    float r = (tint.r * tint.a) + (clr.r);
    float g = (tint.g * tint.a) + (clr.g);
    float b = (tint.b * tint.a) + (clr.b);

    gl_FragColor = (clr.r + clr.b + clr.g == 0.0) ? clr : vec4(r, g, b, clr.a);
}