#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

// libgdx default:
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

// params:
uniform sampler2D terminal_source;
uniform float burn_time;
uniform float delta;

void main() {
    vec2 tc = v_texCoords;

    float burn_coefficent = delta / burn_time;

    vec3 source_color = texture2D(terminal_source, tc).rgb;
    vec3 burn_color = texture2D(u_texture, tc).rgb - vec3(burn_coefficent);

    vec3 output_color = min(source_color + burn_color, max(source_color, burn_color));

	gl_FragColor = vec4(output_color, 1.0);
}
