#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

// libgdx default:
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

// colors:
uniform vec4 fore_color;
uniform vec4 back_color;

// bloom stuff:
uniform sampler2D bloom_source;
uniform float bloom;
uniform float brightness;

// burnin
uniform sampler2D burn_source;

// get intensity of color
float color_intensity(vec3 color) {
    return dot(color, vec3(0.21, 0.72, 0.04));
}

void main() {
    vec2 tc = v_texCoords;

    // raw terminal input color:
    vec3 source_color = texture2D(u_texture, tc).rgb;

    vec3 burn_color = texture2D(burn_source, tc).rgb;

    // setup source intensity and output color (will be modified by bloom after)
    float source_intensity = max(color_intensity(source_color), color_intensity(burn_color));
    vec3 output_color = mix(back_color.rgb, fore_color.rgb, source_intensity);

    // handle bloom
    vec4 bloom_color = texture2D(bloom_source, tc);

    float bloom_intensity = color_intensity(bloom_color.rgb);
    vec3 bloom_out = (fore_color.rgb * bloom_intensity);
    vec3 bloomed_output_color = (output_color * 1.5) + (bloom_out * bloom);

    // determine output alpha
    float alpha = (source_intensity + bloom_intensity < 0.05) ? 0.0 : 1.0;
    //float alpha = source_intensity + (bloom_intensity * 4);

	gl_FragColor = vec4(bloomed_output_color, alpha);
}
