#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

// libgdx default:
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform float u_time;
uniform float u_shibe_y_position;

void main() {
    vec4 color = texture2D(u_texture, v_texCoords);

    float y_distance = abs(v_texCoords.y - u_shibe_y_position);

    // need inner threshold of distance where it becomes pure white
    float inner_threshold = u_time;
    float whiteness = 0.0;

    float thresh_step = (16.0 / 360.0) * u_time;

    if (y_distance < inner_threshold) {
        whiteness = 1.0;
    } else if (y_distance < inner_threshold + thresh_step * 1.0) {
        whiteness = 0.8;
    } else if (y_distance < inner_threshold + thresh_step * 4.0){
        whiteness = 0.6;
    } else if (y_distance < inner_threshold + thresh_step * 12.0) {
        whiteness = 0.4;
    } else {
        whiteness = 0.0;
    }

    // blend using whiteness as alpha
    float color_alpha = 1.0 - whiteness;
    float r = (1.0 * whiteness) + (color.r * color_alpha);
    float g = (1.0 * whiteness) + (color.g * color_alpha);
    float b = (1.0 * whiteness) + (color.b * color_alpha);


	gl_FragColor = vec4(r, g, b, 1.0);
}