#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

// libgdx default:
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

// scaling:
uniform int scale;
uniform vec2 output_resolution;
uniform vec2 input_resolution;

float soft_light(float base, float blend) {
    return ((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)));
}

vec3 scanline_overlay(float y) {
    int line = int(floor(y * output_resolution.y));

    int light_lines = scale / 2;
    int dark_lines = scale - light_lines;
    int leading_dark_lines = dark_lines / 2;
    float current_internal_line = mod(line, scale) + 1;

    if (current_internal_line <= leading_dark_lines || current_internal_line > leading_dark_lines + light_lines) {
        return vec3(0.31);
    } else {
        return vec3(0.61);
    }
}

vec3 blurred(vec2 tc, float blur) {
    float hstep = 1.0;

    vec4 sum = vec4(0.0);

    sum += texture2D(u_texture, vec2(tc.x - 4.0*blur*hstep, tc.y)) * 0.0162162162;
    sum += texture2D(u_texture, vec2(tc.x - 3.0*blur*hstep, tc.y)) * 0.0540540541;
    sum += texture2D(u_texture, vec2(tc.x - 2.0*blur*hstep, tc.y)) * 0.1216216216;
    sum += texture2D(u_texture, vec2(tc.x - 1.0*blur*hstep, tc.y)) * 0.1945945946;

    sum += texture2D(u_texture, vec2(tc.x, tc.y)) * 0.2270270270;

    sum += texture2D(u_texture, vec2(tc.x + 1.0*blur*hstep, tc.y)) * 0.1945945946;
    sum += texture2D(u_texture, vec2(tc.x + 2.0*blur*hstep, tc.y)) * 0.1216216216;
    sum += texture2D(u_texture, vec2(tc.x + 3.0*blur*hstep, tc.y)) * 0.0540540541;
    sum += texture2D(u_texture, vec2(tc.x + 4.0*blur*hstep, tc.y)) * 0.0162162162;
    return sum.rgb;
}

void main() {
    vec2 tc = v_texCoords;

    vec4 og_input_color = texture2D(u_texture, tc).rgba;

    float radius = scale / 6.0;

    vec3 input_color = blurred(tc, radius / output_resolution.x);

    vec3 scanline_color = scanline_overlay(tc.y);

    vec3 adj_input = input_color.rgb * vec3(1.0);

    vec3 blended = vec3(soft_light(adj_input.r, scanline_color.r), soft_light(adj_input.g, scanline_color.g), soft_light(adj_input.b, scanline_color.b));

    vec3 adj_output = blended / vec3(1.0);

    vec3 aber_output = vec3(0.0);

    if (og_input_color.g < 0.01 && og_input_color.r < 0.01) {
        aber_output = vec3(0.0, 0.0, adj_output.b * 1.5);
    } else {
        aber_output = adj_output;
    }

	gl_FragColor = vec4(aber_output, og_input_color.a);
}
