#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

#define PALETTE_ENTRIES 8

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform vec3[PALETTE_ENTRIES] in_colors;
uniform vec3[PALETTE_ENTRIES] out_colors;

void main() {
    vec4 original_color = texture2D(u_texture, v_texCoords);
    vec3 original_rgb = original_color.rgb;

    vec3 out_rgb = vec3(0.0);

    for(int i = 0; i < PALETTE_ENTRIES; i++) {
        if (in_colors[i] == original_rgb) {
            out_rgb = out_colors[i];
            break;
        }
    }

	gl_FragColor = vec4(out_rgb, original_color.a);
}