#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform vec4 u_overlay_color;
uniform float u_alpha_override;
uniform float u_y_cutoff;

float q(float in_color) {
    float q3 = floor((in_color * 7.0) + 0.5) / 7.0;
    return floor(q3 * 255.0) / 255.0;
}

void main() {
    vec4 color = texture2D(u_texture, v_texCoords);

    if (v_texCoords.y <= u_y_cutoff) {
        float base_alpha = 1.0 - u_overlay_color.a;
        float overlay_alpha = u_overlay_color.a;

        // quantize input
        float ri = q(color.r);
        float gi = q(color.g);
        float bi = q(color.b);

        float r = (ri * base_alpha) + (u_overlay_color.r * overlay_alpha);
        float g = (gi * base_alpha) + (u_overlay_color.g * overlay_alpha);
        float b = (bi * base_alpha) + (u_overlay_color.b * overlay_alpha);

        // quantize output
        float rq = q(r);
        float gq = q(g);
        float bq = q(b);

    	gl_FragColor = vec4(rq, gq, bq, max(color.a, u_alpha_override));
    } else {
        gl_FragColor = color;
    }
}
