#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

float q(float in_color) {
    float q3 = floor((in_color * 7.0) + 0.5) / 7.0;
    return floor(q3 * 255.0) / 255.0;
}

void main() {
    vec4 color = texture2D(u_texture, v_texCoords);
    gl_FragColor = vec4(q(color.r), q(color.g), q(color.b), 1.0);
}
