#version 130
//#ifdef GL_ES
//  #define LOWP lowp
//  precision mediump float;
//#else
  //#define LOWP
//#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform sampler2D source_map;
uniform sampler2D target_map;
uniform int palette;
uniform int src_palette;

#define epsilon 0.05

void main() {
    // start with actual color
    vec4 output_color = texture2D(u_texture, v_texCoords);

    int srcHeight = textureSize(source_map, 0).y;
    int targetHeight = textureSize(target_map, 0).y;

    if (output_color.a == 0) {
        // ignore this pixel if the source color is fully transparent
        gl_FragColor = output_color;
    } else {
        vec4 remap_color = output_color;

        // iterate over all rows of the mapping
        for (int n = 0; n < srcHeight && n < targetHeight; n++) {
            vec4 refColor = texelFetch(source_map, ivec2(src_palette, n), 0);

            // if the reference color matches our current output color, replace the output color
            // with the its entry for the current palette
            float rd = abs(refColor.r - output_color.r);
            float gd = abs(refColor.g - output_color.g);
            float bd = abs(refColor.b - output_color.b);

            if (rd < epsilon && gd < epsilon && bd < epsilon) {
                vec4 targetColor = texelFetch(target_map, ivec2(palette, n), 0);
                remap_color = vec4(targetColor.rgb, 1.0);
            }
        }

        output_color = remap_color;

        gl_FragColor = output_color;
    }
}
