#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform vec4 u_overlay_color;
uniform float u_alpha_override;

void main() {
    vec4 color = texture2D(u_texture, v_texCoords);

    float base_alpha = 1.0 - u_overlay_color.a;
    float overlay_alpha = u_overlay_color.a;

    float r = (color.r * base_alpha) + (u_overlay_color.r * overlay_alpha);
    float g = (color.g * base_alpha) + (u_overlay_color.g * overlay_alpha);
    float b = (color.b * base_alpha) + (u_overlay_color.b * overlay_alpha);

	gl_FragColor = vec4(r, g, b, max(color.a, u_alpha_override));
}