#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform vec4 outline_color;
uniform vec2 texture_size;
uniform float vertex_contribution;
uniform int diagonals;

void main() {
	vec4 base_color = texture2D(u_texture, v_texCoords);

	if (base_color.a > 0) {
	    gl_FragColor = base_color * (v_color * vertex_contribution);
	} else {
	    vec2 stepSize = 1.0 / texture_size;
        vec4 sum = vec4(0.0);
        // check surrounding pixels
        sum += texture2D(u_texture, vec2(v_texCoords.x - stepSize.x, v_texCoords.y));
        sum += texture2D(u_texture, vec2(v_texCoords.x + stepSize.x, v_texCoords.y));

        sum += texture2D(u_texture, vec2(v_texCoords.x, v_texCoords.y - stepSize.y));
        sum += texture2D(u_texture, vec2(v_texCoords.x, v_texCoords.y + stepSize.y));

        if (diagonals == 1) {
            sum += texture2D(u_texture, vec2(v_texCoords.x + stepSize.x, v_texCoords.y + stepSize.y));
            sum += texture2D(u_texture, vec2(v_texCoords.x + stepSize.x, v_texCoords.y - stepSize.y));
            sum += texture2D(u_texture, vec2(v_texCoords.x - stepSize.x, v_texCoords.y + stepSize.y));
            sum += texture2D(u_texture, vec2(v_texCoords.x - stepSize.x, v_texCoords.y - stepSize.y));
        }

        sum.a = sum.a > 0 ? 1.0 : 0.0;

        float vertex_alpha = vertex_contribution > 0 ? v_color.a : 1.0;

	    gl_FragColor = vec4(outline_color.rgb, outline_color.a * sum.a * vertex_alpha);
	}
}
