#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform vec4 glow_color;
uniform vec2 texture_size;

// bloom
uniform sampler2D bloom_source;
uniform float bloom;

void main() {
    vec4 source_color = texture2D(u_texture, v_texCoords);

    vec4 bloom_color = texture2D(bloom_source, v_texCoords);

    vec3 out_color = mix(source_color.rgb, glow_color.rgb, bloom_color.a * bloom);

	gl_FragColor = vec4(out_color, source_color.a);
}
