#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform float u_time;
uniform mat4 u_dissolve;

void main() {
  vec4 original_color = texture2D(u_texture, v_texCoords);

  float px = v_texCoords.x * 4096.0;
  float py = v_texCoords.y * 4096.0;

  int mx = int(mod(px, 4.0));
  int my = int(mod(py, 4.0));

  gl_FragColor = (u_time > u_dissolve[my][mx]) ? vec4(0.0, 0.0, 0.0, 1.0) : original_color;
}