#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform vec2 texture_size;

void main() {
    vec4 base_color = texture2D(u_texture, v_texCoords);

    vec4 black = vec4(0.0, 0.0, 0.0, 1.0);
    vec4 white = vec4(1.0, 1.0, 1.0, 1.0);

    vec4 inner_color = vec4(0.972, 0.721, 0.0, 1.0);
    vec4 glow_color = vec4(0.313, 0.188, 0.0, 1.0);

    if (base_color.a == 0) {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
    } else if (base_color == vec4(0.0, 0.0, 1.0, 1.0)) {
        gl_FragColor = glow_color;
    } else if (base_color.r > 0) {
        gl_FragColor = inner_color;
    } else {
        vec2 stepSize = 1.0 / texture_size;
        vec4 sum = vec4(0.0);

        sum += texture2D(u_texture, vec2(v_texCoords.x - stepSize.x, v_texCoords.y));
        sum += texture2D(u_texture, vec2(v_texCoords.x + stepSize.x, v_texCoords.y));
        sum += texture2D(u_texture, vec2(v_texCoords.x, v_texCoords.y - stepSize.y));

        float py = v_texCoords.y * texture_size.y;

        int my = int(mod(py + 1.0, 8.0));

        if (my != 0) {
            sum += texture2D(u_texture, vec2(v_texCoords.x, v_texCoords.y + stepSize.y));
            //gl_FragColor = vec4(0.0, 0.0, 1.0, 1.0);
        }

        gl_FragColor = sum.r > 0 ? glow_color : black;
    }
}
