#version 130

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform vec3 target_color;

#define epsilon 0.05

void main() {
    vec4 output_color = texture2D(u_texture, v_texCoords);

    float rd = abs(0.0 - output_color.r);
    float gd = abs(0.0 - output_color.g);
    float bd = abs(0.0 - output_color.b);

    if (rd < epsilon && gd < epsilon && bd < epsilon) {
        output_color = vec4(target_color.rgb, 1.0);
    }

	gl_FragColor = output_color;
}
