#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform vec4 outline_color;
uniform float intensity;

vec4 blur5(sampler2D image, vec2 uv, vec2 resolution, vec2 direction) {
  vec4 color = vec4(0.0);
  vec2 off1 = vec2(1.3333333333333333) * direction;
  color += texture2D(image, uv) * 0.29411764705882354;
  color += texture2D(image, uv + (off1 / resolution)) * 0.35294117647058826;
  color += texture2D(image, uv - (off1 / resolution)) * 0.35294117647058826;
  return color;
}

vec4 blur9(sampler2D image, vec2 uv, vec2 resolution, vec2 direction) {
  vec4 color = vec4(0.0);
  vec2 off1 = vec2(1.3846153846) * direction;
  vec2 off2 = vec2(3.2307692308) * direction;
  color += texture2D(image, uv) * 0.2270270270;
  color += texture2D(image, uv + (off1 / resolution)) * 0.3162162162;
  color += texture2D(image, uv - (off1 / resolution)) * 0.3162162162;
  color += texture2D(image, uv + (off2 / resolution)) * 0.0702702703;
  color += texture2D(image, uv - (off2 / resolution)) * 0.0702702703;
  return color;
}

vec4 blur13(sampler2D image, vec2 uv, vec2 resolution, vec2 direction) {
  vec4 color = vec4(0.0);
  vec2 off1 = vec2(1.411764705882353) * direction;
  vec2 off2 = vec2(3.2941176470588234) * direction;
  vec2 off3 = vec2(5.176470588235294) * direction;
  color += texture2D(image, uv) * 0.1964825501511404;
  color += texture2D(image, uv + (off1 / resolution)) * 0.2969069646728344;
  color += texture2D(image, uv - (off1 / resolution)) * 0.2969069646728344;
  color += texture2D(image, uv + (off2 / resolution)) * 0.09447039785044732;
  color += texture2D(image, uv - (off2 / resolution)) * 0.09447039785044732;
  color += texture2D(image, uv + (off3 / resolution)) * 0.010381362401148057;
  color += texture2D(image, uv - (off3 / resolution)) * 0.010381362401148057;
  return color;
}

vec4 glow(sampler2D texture) {
    float glow_size = 10.0;
    vec3 glow_color = vec3(0.0, 0.0, 1.0);
    float glow_intensity = 1.0;
    float glow_threshold = 0.5;

    vec4 color = texture2D(texture, v_texCoords);

    if (color.a <= glow_threshold) {
        vec2 size = vec2(4096, 4096);

        float uv_x = v_texCoords.x * size.x;
        float uv_y = v_texCoords.y * size.y;

        float sum = 0.0;

        for (int n = 0; n < 9; ++n) {
           uv_y = (v_texCoords.y * size.y) + (glow_size * float(n - 4.5));
           float h_sum = 0.0;
           h_sum += texture2D(texture, vec2(uv_x - (4.0 * glow_size), uv_y), 0).a;
           h_sum += texture2D(texture, vec2(uv_x - (3.0 * glow_size), uv_y), 0).a;
           h_sum += texture2D(texture, vec2(uv_x - (2.0 * glow_size), uv_y), 0).a;
           h_sum += texture2D(texture, vec2(uv_x - glow_size, uv_y), 0).a;
           h_sum += texture2D(texture, vec2(uv_x, uv_y), 0).a;
           h_sum += texture2D(texture, vec2(uv_x + glow_size, uv_y), 0).a;
           h_sum += texture2D(texture, vec2(uv_x + (2.0 * glow_size), uv_y), 0).a;
           h_sum += texture2D(texture, vec2(uv_x + (3.0 * glow_size), uv_y), 0).a;
           h_sum += texture2D(texture, vec2(uv_x + (4.0 * glow_size), uv_y), 0).a;
           sum += h_sum / 9.0;
        }

        color = vec4(glow_color, (sum / 9.0) * glow_intensity);
    }

    return color;
}

vec4 outline(sampler2D image, float step, float intensity) {
    vec2 stepSize = step / vec2(4096.0, 4096.0);
    vec4 sum = vec4(0.0);

    sum += texture2D(u_texture, vec2(v_texCoords.x - stepSize.x, v_texCoords.y - stepSize.y));
    sum += texture2D(u_texture, vec2(v_texCoords.x, v_texCoords.y - stepSize.y));
    sum += texture2D(u_texture, vec2(v_texCoords.x + stepSize.x, v_texCoords.y - stepSize.y));
    sum += texture2D(u_texture, vec2(v_texCoords.x - stepSize.x, v_texCoords.y));
    //sum += texture2D(u_texture, vec2(v_texCoords.x, v_texCoords.y));
    sum += texture2D(u_texture, vec2(v_texCoords.x + stepSize.x, v_texCoords.y));
    sum += texture2D(u_texture, vec2(v_texCoords.x - stepSize.x, v_texCoords.y + stepSize.y));
    sum += texture2D(u_texture, vec2(v_texCoords.x, v_texCoords.y + stepSize.y));
    sum += texture2D(u_texture, vec2(v_texCoords.x + stepSize.x, v_texCoords.y + stepSize.y));
    return sum / (step / intensity);
}

void main() {
    vec4 baseColor = texture2D(u_texture, v_texCoords);

    if (baseColor.a <= 0) {
        vec4 outline = outline(u_texture, 1.0, intensity) +
                       outline(u_texture, 2.0, intensity) +
                       outline(u_texture, 3.0, intensity) +
                       outline(u_texture, 4.0, intensity) +
                       outline(u_texture, 5.0, intensity) +
                       outline(u_texture, 6.0, intensity);

        float sumAlpha = clamp(outline.a, 0.0, 1.0);

        gl_FragColor = vec4(outline_color.rgb, sumAlpha * v_color.a * outline_color.a);
    } else {
        gl_FragColor = baseColor;
    }
}
