#version 120
#ifdef GL_ES
  #define LOWP lowp
  precision mediump float;
#else
  #define LOWP
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

uniform sampler2D mask;
uniform int mode;

void main() {
    vec4 source_color = texture2D(u_texture, v_texCoords);
    vec4 mask_color = texture2D(mask, v_texCoords);

    vec4 clear = vec4(0.0);

    vec4 gt = mode == 0 ? source_color : clear;
    vec4 lte = mode == 0 ? clear : source_color;

    if (mask_color.a > 0) {
        gl_FragColor = gt;
    } else {
        gl_FragColor = lte;
    }
}
