/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vector;

import java.io.Serializable;
import java.nio.FloatBuffer;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector;
import org.lwjgl.util.vector.WritableVector4f;

public class Vector4f
extends Vector
implements Serializable,
ReadableVector4f,
WritableVector4f {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
    }

    public Vector4f(ReadableVector4f readableVector4f) {
        this.set(readableVector4f);
    }

    public Vector4f(float f2, float f3, float f4, float f5) {
        this.set(f2, f3, f4, f5);
    }

    public void set(float f2, float f3) {
        this.x = f2;
        this.y = f3;
    }

    public void set(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
    }

    public void set(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public Vector4f set(ReadableVector4f readableVector4f) {
        this.x = readableVector4f.getX();
        this.y = readableVector4f.getY();
        this.z = readableVector4f.getZ();
        this.w = readableVector4f.getW();
        return this;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Vector4f translate(float f2, float f3, float f4, float f5) {
        this.x += f2;
        this.y += f3;
        this.z += f4;
        this.w += f5;
        return this;
    }

    public static Vector4f add(Vector4f vector4f, Vector4f vector4f2, Vector4f vector4f3) {
        if (vector4f3 == null) {
            return new Vector4f(vector4f.x + vector4f2.x, vector4f.y + vector4f2.y, vector4f.z + vector4f2.z, vector4f.w + vector4f2.w);
        }
        vector4f3.set(vector4f.x + vector4f2.x, vector4f.y + vector4f2.y, vector4f.z + vector4f2.z, vector4f.w + vector4f2.w);
        return vector4f3;
    }

    public static Vector4f sub(Vector4f vector4f, Vector4f vector4f2, Vector4f vector4f3) {
        if (vector4f3 == null) {
            return new Vector4f(vector4f.x - vector4f2.x, vector4f.y - vector4f2.y, vector4f.z - vector4f2.z, vector4f.w - vector4f2.w);
        }
        vector4f3.set(vector4f.x - vector4f2.x, vector4f.y - vector4f2.y, vector4f.z - vector4f2.z, vector4f.w - vector4f2.w);
        return vector4f3;
    }

    public Vector negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4f negate(Vector4f vector4f) {
        if (vector4f == null) {
            vector4f = new Vector4f();
        }
        vector4f.x = -this.x;
        vector4f.y = -this.y;
        vector4f.z = -this.z;
        vector4f.w = -this.w;
        return vector4f;
    }

    public Vector4f normalise(Vector4f vector4f) {
        float f2 = this.length();
        if (vector4f == null) {
            vector4f = new Vector4f(this.x / f2, this.y / f2, this.z / f2, this.w / f2);
        } else {
            vector4f.set(this.x / f2, this.y / f2, this.z / f2, this.w / f2);
        }
        return vector4f;
    }

    public static float dot(Vector4f vector4f, Vector4f vector4f2) {
        return vector4f.x * vector4f2.x + vector4f.y * vector4f2.y + vector4f.z * vector4f2.z + vector4f.w * vector4f2.w;
    }

    public static float angle(Vector4f vector4f, Vector4f vector4f2) {
        float f2 = Vector4f.dot(vector4f, vector4f2) / (vector4f.length() * vector4f2.length());
        if (f2 < -1.0f) {
            f2 = -1.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return (float)Math.acos(f2);
    }

    public Vector load(FloatBuffer floatBuffer) {
        this.x = floatBuffer.get();
        this.y = floatBuffer.get();
        this.z = floatBuffer.get();
        this.w = floatBuffer.get();
        return this;
    }

    public Vector scale(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
        return this;
    }

    public Vector store(FloatBuffer floatBuffer) {
        floatBuffer.put(this.x);
        floatBuffer.put(this.y);
        floatBuffer.put(this.z);
        floatBuffer.put(this.w);
        return this;
    }

    public String toString() {
        return "Vector4f: " + this.x + " " + this.y + " " + this.z + " " + this.w;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final void setX(float f2) {
        this.x = f2;
    }

    public final void setY(float f2) {
        this.y = f2;
    }

    public void setZ(float f2) {
        this.z = f2;
    }

    public float getZ() {
        return this.z;
    }

    public void setW(float f2) {
        this.w = f2;
    }

    public float getW() {
        return this.w;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector4f vector4f = (Vector4f)object;
        return this.x == vector4f.x && this.y == vector4f.y && this.z == vector4f.z && this.w == vector4f.w;
    }
}

