/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vector;

import java.io.Serializable;
import java.nio.FloatBuffer;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector;
import org.lwjgl.util.vector.WritableVector2f;

public class Vector2f
extends Vector
implements Serializable,
ReadableVector2f,
WritableVector2f {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(ReadableVector2f readableVector2f) {
        this.set(readableVector2f);
    }

    public Vector2f(float f2, float f3) {
        this.set(f2, f3);
    }

    public void set(float f2, float f3) {
        this.x = f2;
        this.y = f3;
    }

    public Vector2f set(ReadableVector2f readableVector2f) {
        this.x = readableVector2f.getX();
        this.y = readableVector2f.getY();
        return this;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2f translate(float f2, float f3) {
        this.x += f2;
        this.y += f3;
        return this;
    }

    public Vector negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f negate(Vector2f vector2f) {
        if (vector2f == null) {
            vector2f = new Vector2f();
        }
        vector2f.x = -this.x;
        vector2f.y = -this.y;
        return vector2f;
    }

    public Vector2f normalise(Vector2f vector2f) {
        float f2 = this.length();
        if (vector2f == null) {
            vector2f = new Vector2f(this.x / f2, this.y / f2);
        } else {
            vector2f.set(this.x / f2, this.y / f2);
        }
        return vector2f;
    }

    public static float dot(Vector2f vector2f, Vector2f vector2f2) {
        return vector2f.x * vector2f2.x + vector2f.y * vector2f2.y;
    }

    public static float angle(Vector2f vector2f, Vector2f vector2f2) {
        float f2 = Vector2f.dot(vector2f, vector2f2) / (vector2f.length() * vector2f2.length());
        if (f2 < -1.0f) {
            f2 = -1.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return (float)Math.acos(f2);
    }

    public static Vector2f add(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        if (vector2f3 == null) {
            return new Vector2f(vector2f.x + vector2f2.x, vector2f.y + vector2f2.y);
        }
        vector2f3.set(vector2f.x + vector2f2.x, vector2f.y + vector2f2.y);
        return vector2f3;
    }

    public static Vector2f sub(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        if (vector2f3 == null) {
            return new Vector2f(vector2f.x - vector2f2.x, vector2f.y - vector2f2.y);
        }
        vector2f3.set(vector2f.x - vector2f2.x, vector2f.y - vector2f2.y);
        return vector2f3;
    }

    public Vector store(FloatBuffer floatBuffer) {
        floatBuffer.put(this.x);
        floatBuffer.put(this.y);
        return this;
    }

    public Vector load(FloatBuffer floatBuffer) {
        this.x = floatBuffer.get();
        this.y = floatBuffer.get();
        return this;
    }

    public Vector scale(float f2) {
        this.x *= f2;
        this.y *= f2;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("Vector2f[");
        stringBuilder.append(this.x);
        stringBuilder.append(", ");
        stringBuilder.append(this.y);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final void setX(float f2) {
        this.x = f2;
    }

    public final void setY(float f2) {
        this.y = f2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector2f vector2f = (Vector2f)object;
        return this.x == vector2f.x && this.y == vector2f.y;
    }
}

