/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.mapped;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MappedObjectUnsafe {
    static final Unsafe INSTANCE = MappedObjectUnsafe.getUnsafeInstance();
    private static final long BUFFER_ADDRESS_OFFSET = MappedObjectUnsafe.getObjectFieldOffset(ByteBuffer.class, "address");
    private static final long BUFFER_CAPACITY_OFFSET = MappedObjectUnsafe.getObjectFieldOffset(ByteBuffer.class, "capacity");
    private static final ByteBuffer global = ByteBuffer.allocateDirect(4096);

    MappedObjectUnsafe() {
    }

    static ByteBuffer newBuffer(long l2, int n2) {
        if (l2 <= 0L || n2 < 0) {
            throw new IllegalStateException("you almost crashed the jvm");
        }
        ByteBuffer byteBuffer = global.duplicate().order(ByteOrder.nativeOrder());
        INSTANCE.putLong(byteBuffer, BUFFER_ADDRESS_OFFSET, l2);
        INSTANCE.putInt(byteBuffer, BUFFER_CAPACITY_OFFSET, n2);
        byteBuffer.position(0);
        byteBuffer.limit(n2);
        return byteBuffer;
    }

    private static long getObjectFieldOffset(Class<?> clazz, String string) {
        while (clazz != null) {
            try {
                return INSTANCE.objectFieldOffset(clazz.getDeclaredField(string));
            }
            catch (Throwable throwable) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Unsafe getUnsafeInstance() {
        Field[] fieldArray;
        for (Field field : fieldArray = Unsafe.class.getDeclaredFields()) {
            int n2;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(n2 = field.getModifiers()) || !Modifier.isFinal(n2)) continue;
            field.setAccessible(true);
            try {
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                break;
            }
        }
        throw new UnsupportedOperationException();
    }
}

