/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.mapped;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.util.mapped.CacheLinePad;
import org.lwjgl.util.mapped.CacheUtil;
import org.lwjgl.util.mapped.MappedField;
import org.lwjgl.util.mapped.MappedHelper;
import org.lwjgl.util.mapped.MappedObject;
import org.lwjgl.util.mapped.MappedObjectClassLoader;
import org.lwjgl.util.mapped.MappedObjectUnsafe;
import org.lwjgl.util.mapped.MappedSet;
import org.lwjgl.util.mapped.MappedSet2;
import org.lwjgl.util.mapped.MappedSet3;
import org.lwjgl.util.mapped.MappedSet4;
import org.lwjgl.util.mapped.MappedType;
import org.lwjgl.util.mapped.Pointer;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.util.TraceClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedObjectTransformer {
    static final boolean PRINT_ACTIVITY = LWJGLUtil.DEBUG && LWJGLUtil.getPrivilegedBoolean("org.lwjgl.util.mapped.PrintActivity");
    static final boolean PRINT_TIMING = PRINT_ACTIVITY && LWJGLUtil.getPrivilegedBoolean("org.lwjgl.util.mapped.PrintTiming");
    static final boolean PRINT_BYTECODE = LWJGLUtil.DEBUG && LWJGLUtil.getPrivilegedBoolean("org.lwjgl.util.mapped.PrintBytecode");
    static final Map<String, MappedSubtypeInfo> className_to_subtype;
    static final String MAPPED_OBJECT_JVM;
    static final String MAPPED_HELPER_JVM;
    static final String MAPPEDSET_PREFIX;
    static final String MAPPED_SET2_JVM;
    static final String MAPPED_SET3_JVM;
    static final String MAPPED_SET4_JVM;
    static final String CACHE_LINE_PAD_JVM;
    static final String VIEWADDRESS_METHOD_NAME = "getViewAddress";
    static final String NEXT_METHOD_NAME = "next";
    static final String ALIGN_METHOD_NAME = "getAlign";
    static final String SIZEOF_METHOD_NAME = "getSizeof";
    static final String CAPACITY_METHOD_NAME = "capacity";
    static final String VIEW_CONSTRUCTOR_NAME = "constructView$LWJGL";
    static final Map<Integer, String> OPCODE_TO_NAME;
    static final Map<Integer, String> INSNTYPE_TO_NAME;
    static boolean is_currently_computing_frames;

    public static void register(Class<? extends MappedObject> clazz) {
        MappedSubtypeInfo mappedSubtypeInfo;
        int n2;
        if (MappedObjectClassLoader.FORKED) {
            return;
        }
        MappedType mappedType = clazz.getAnnotation(MappedType.class);
        if (mappedType != null && mappedType.padding() < 0) {
            throw new ClassFormatError("Invalid mapped type padding: " + mappedType.padding());
        }
        if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
            throw new InternalError("only top-level or static inner classes are allowed");
        }
        String string = MappedObjectTransformer.jvmClassName(clazz);
        HashMap<String, FieldInfo> hashMap = new HashMap<String, FieldInfo>();
        long l2 = 0L;
        Field[] fieldArray = clazz.getDeclaredFields();
        int n3 = fieldArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            Field field;
            FieldInfo fieldInfo = MappedObjectTransformer.registerField(mappedType == null || mappedType.autoGenerateOffsets(), string, l2, field = fieldArray[n2]);
            if (fieldInfo == null) continue;
            hashMap.put(field.getName(), fieldInfo);
            l2 = Math.max(l2, fieldInfo.offset + fieldInfo.lengthPadded);
        }
        int n4 = 4;
        n3 = 0;
        n2 = 0;
        if (mappedType != null) {
            n4 = mappedType.align();
            if (mappedType.cacheLinePadding()) {
                if (mappedType.padding() != 0) {
                    throw new ClassFormatError("Mapped type padding cannot be specified together with cacheLinePadding.");
                }
                int n5 = (int)(l2 % (long)CacheUtil.getCacheLineSize());
                if (n5 != 0) {
                    n3 = CacheUtil.getCacheLineSize() - n5;
                }
                n2 = 1;
            } else {
                n3 = mappedType.padding();
            }
        }
        if (className_to_subtype.put(string, mappedSubtypeInfo = new MappedSubtypeInfo(string, hashMap, (int)(l2 += (long)n3), n4, n3, n2 != 0)) != null) {
            throw new InternalError("duplicate mapped type: " + mappedSubtypeInfo.className);
        }
    }

    private static FieldInfo registerField(boolean bl2, String string, long l2, Field field) {
        long l3;
        if (Modifier.isStatic(field.getModifiers())) {
            return null;
        }
        if (!field.getType().isPrimitive() && field.getType() != ByteBuffer.class) {
            throw new ClassFormatError("field '" + string + "." + field.getName() + "' not supported: " + field.getType());
        }
        MappedField mappedField = field.getAnnotation(MappedField.class);
        if (mappedField == null && !bl2) {
            throw new ClassFormatError("field '" + string + "." + field.getName() + "' missing annotation " + MappedField.class.getName() + ": " + string);
        }
        Pointer pointer = field.getAnnotation(Pointer.class);
        if (pointer != null && field.getType() != Long.TYPE) {
            throw new ClassFormatError("The @Pointer annotation can only be used on long fields. @Pointer field found: " + string + "." + field.getName() + ": " + field.getType());
        }
        if (Modifier.isVolatile(field.getModifiers()) && (pointer != null || field.getType() == ByteBuffer.class)) {
            throw new ClassFormatError("The volatile keyword is not supported for @Pointer or ByteBuffer fields. Volatile field found: " + string + "." + field.getName() + ": " + field.getType());
        }
        if (field.getType() == Long.TYPE || field.getType() == Double.TYPE) {
            l3 = pointer == null ? 8L : (long)MappedObjectUnsafe.INSTANCE.addressSize();
        } else if (field.getType() == Double.TYPE) {
            l3 = 8L;
        } else if (field.getType() == Integer.TYPE || field.getType() == Float.TYPE) {
            l3 = 4L;
        } else if (field.getType() == Character.TYPE || field.getType() == Short.TYPE) {
            l3 = 2L;
        } else if (field.getType() == Byte.TYPE) {
            l3 = 1L;
        } else if (field.getType() == ByteBuffer.class) {
            l3 = mappedField.byteLength();
            if (l3 < 0L) {
                throw new IllegalStateException("invalid byte length for mapped ByteBuffer field: " + string + "." + field.getName() + " [length=" + l3 + "]");
            }
        } else {
            throw new ClassFormatError(field.getType().getName());
        }
        if (field.getType() != ByteBuffer.class && l2 % l3 != 0L) {
            throw new IllegalStateException("misaligned mapped type: " + string + "." + field.getName());
        }
        CacheLinePad cacheLinePad = field.getAnnotation(CacheLinePad.class);
        long l4 = l2;
        if (mappedField != null && mappedField.byteOffset() != -1L) {
            if (mappedField.byteOffset() < 0L) {
                throw new ClassFormatError("Invalid field byte offset: " + string + "." + field.getName() + " [byteOffset=" + mappedField.byteOffset() + "]");
            }
            if (cacheLinePad != null) {
                throw new ClassFormatError("A field byte offset cannot be specified together with cache-line padding: " + string + "." + field.getName());
            }
            l4 = mappedField.byteOffset();
        }
        long l5 = l3;
        if (cacheLinePad != null) {
            if (cacheLinePad.before() && l4 % (long)CacheUtil.getCacheLineSize() != 0L) {
                l4 += (long)CacheUtil.getCacheLineSize() - (l4 & (long)(CacheUtil.getCacheLineSize() - 1));
            }
            if (cacheLinePad.after() && (l4 + l3) % (long)CacheUtil.getCacheLineSize() != 0L) {
                l5 += (long)CacheUtil.getCacheLineSize() - (l4 + l3) % (long)CacheUtil.getCacheLineSize();
            }
            assert (!cacheLinePad.before() || l4 % (long)CacheUtil.getCacheLineSize() == 0L);
            assert (!cacheLinePad.after() || (l4 + l5) % (long)CacheUtil.getCacheLineSize() == 0L);
        }
        if (PRINT_ACTIVITY) {
            LWJGLUtil.log(MappedObjectTransformer.class.getSimpleName() + ": " + string + "." + field.getName() + " [type=" + field.getType().getSimpleName() + ", offset=" + l4 + "]");
        }
        return new FieldInfo(l4, l3, l5, Type.getType(field.getType()), Modifier.isVolatile(field.getModifiers()), pointer != null);
    }

    static byte[] transformMappedObject(byte[] byArray) {
        ClassWriter classWriter = new ClassWriter(0);
        ClassAdapter classAdapter = new ClassAdapter((ClassVisitor)classWriter){
            private final String[] DEFINALIZE_LIST = new String[]{"getViewAddress", "next", "getAlign", "getSizeof", "capacity"};

            public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
                for (String string4 : this.DEFINALIZE_LIST) {
                    if (!string.equals(string4)) continue;
                    n2 &= 0xFFFFFFEF;
                    break;
                }
                return super.visitMethod(n2, string, string2, string3, stringArray);
            }
        };
        new ClassReader(byArray).accept((ClassVisitor)classAdapter, 0);
        return classWriter.toByteArray();
    }

    static byte[] transformMappedAPI(String string, byte[] byArray) {
        TransformationAdapter transformationAdapter;
        ClassWriter classWriter = new ClassWriter(2){

            protected String getCommonSuperClass(String string, String string2) {
                if (is_currently_computing_frames && !string.startsWith("java/") || !string2.startsWith("java/")) {
                    return "java/lang/Object";
                }
                return super.getCommonSuperClass(string, string2);
            }
        };
        TransformationAdapter transformationAdapter2 = transformationAdapter = new TransformationAdapter((ClassVisitor)classWriter, string);
        if (className_to_subtype.containsKey(string)) {
            transformationAdapter2 = MappedObjectTransformer.getMethodGenAdapter(string, (ClassVisitor)transformationAdapter2);
        }
        new ClassReader(byArray).accept((ClassVisitor)transformationAdapter2, 4);
        if (!transformationAdapter.transformed) {
            return byArray;
        }
        byArray = classWriter.toByteArray();
        if (PRINT_BYTECODE) {
            MappedObjectTransformer.printBytecode(byArray);
        }
        return byArray;
    }

    private static ClassAdapter getMethodGenAdapter(final String string, ClassVisitor classVisitor) {
        return new ClassAdapter(classVisitor){

            public void visitEnd() {
                MappedSubtypeInfo mappedSubtypeInfo = className_to_subtype.get(string);
                this.generateViewAddressGetter();
                this.generateCapacity();
                this.generateAlignGetter(mappedSubtypeInfo);
                this.generateSizeofGetter();
                this.generateNext();
                for (String string2 : mappedSubtypeInfo.fields.keySet()) {
                    FieldInfo fieldInfo = mappedSubtypeInfo.fields.get(string2);
                    if (fieldInfo.type.getDescriptor().length() > 1) {
                        this.generateByteBufferGetter(string2, fieldInfo);
                        continue;
                    }
                    this.generateFieldGetter(string2, fieldInfo);
                    this.generateFieldSetter(string2, fieldInfo);
                }
                super.visitEnd();
            }

            private void generateViewAddressGetter() {
                MethodVisitor methodVisitor = super.visitMethod(1, MappedObjectTransformer.VIEWADDRESS_METHOD_NAME, "(I)J", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, MAPPED_OBJECT_JVM, "baseAddress", "J");
                methodVisitor.visitVarInsn(21, 1);
                methodVisitor.visitFieldInsn(178, string, "SIZEOF", "I");
                methodVisitor.visitInsn(104);
                methodVisitor.visitInsn(133);
                methodVisitor.visitInsn(97);
                if (MappedObject.CHECKS) {
                    methodVisitor.visitInsn(92);
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitMethodInsn(184, MAPPED_HELPER_JVM, "checkAddress", "(JL" + MAPPED_OBJECT_JVM + ";)V");
                }
                methodVisitor.visitInsn(173);
                methodVisitor.visitMaxs(3, 2);
                methodVisitor.visitEnd();
            }

            private void generateCapacity() {
                MethodVisitor methodVisitor = super.visitMethod(1, MappedObjectTransformer.CAPACITY_METHOD_NAME, "()I", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, MAPPED_OBJECT_JVM, "backingByteBuffer", "()L" + MappedObjectTransformer.jvmClassName(ByteBuffer.class) + ";");
                methodVisitor.visitInsn(89);
                methodVisitor.visitMethodInsn(182, MappedObjectTransformer.jvmClassName(ByteBuffer.class), MappedObjectTransformer.CAPACITY_METHOD_NAME, "()I");
                methodVisitor.visitInsn(95);
                methodVisitor.visitMethodInsn(184, MappedObjectTransformer.jvmClassName(MemoryUtil.class), "getAddress0", "(L" + MappedObjectTransformer.jvmClassName(Buffer.class) + ";)J");
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, MAPPED_OBJECT_JVM, "baseAddress", "J");
                methodVisitor.visitInsn(101);
                methodVisitor.visitInsn(136);
                methodVisitor.visitInsn(96);
                methodVisitor.visitFieldInsn(178, string, "SIZEOF", "I");
                methodVisitor.visitInsn(108);
                methodVisitor.visitInsn(172);
                methodVisitor.visitMaxs(3, 1);
                methodVisitor.visitEnd();
            }

            private void generateAlignGetter(MappedSubtypeInfo mappedSubtypeInfo) {
                MethodVisitor methodVisitor = super.visitMethod(1, MappedObjectTransformer.ALIGN_METHOD_NAME, "()I", null, null);
                methodVisitor.visitCode();
                MappedObjectTransformer.visitIntNode(methodVisitor, mappedSubtypeInfo.sizeof);
                methodVisitor.visitInsn(172);
                methodVisitor.visitMaxs(1, 1);
                methodVisitor.visitEnd();
            }

            private void generateSizeofGetter() {
                MethodVisitor methodVisitor = super.visitMethod(1, MappedObjectTransformer.SIZEOF_METHOD_NAME, "()I", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitFieldInsn(178, string, "SIZEOF", "I");
                methodVisitor.visitInsn(172);
                methodVisitor.visitMaxs(1, 1);
                methodVisitor.visitEnd();
            }

            private void generateNext() {
                MethodVisitor methodVisitor = super.visitMethod(1, MappedObjectTransformer.NEXT_METHOD_NAME, "()V", null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitInsn(89);
                methodVisitor.visitFieldInsn(180, MAPPED_OBJECT_JVM, "viewAddress", "J");
                methodVisitor.visitFieldInsn(178, string, "SIZEOF", "I");
                methodVisitor.visitInsn(133);
                methodVisitor.visitInsn(97);
                methodVisitor.visitMethodInsn(182, string, "setViewAddress", "(J)V");
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(3, 1);
                methodVisitor.visitEnd();
            }

            private void generateByteBufferGetter(String string2, FieldInfo fieldInfo) {
                MethodVisitor methodVisitor = super.visitMethod(9, MappedObjectTransformer.getterName(string2), "(L" + string + ";I)" + fieldInfo.type.getDescriptor(), null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(21, 1);
                methodVisitor.visitMethodInsn(182, string, MappedObjectTransformer.VIEWADDRESS_METHOD_NAME, "(I)J");
                MappedObjectTransformer.visitIntNode(methodVisitor, (int)fieldInfo.offset);
                methodVisitor.visitInsn(133);
                methodVisitor.visitInsn(97);
                MappedObjectTransformer.visitIntNode(methodVisitor, (int)fieldInfo.length);
                methodVisitor.visitMethodInsn(184, MAPPED_HELPER_JVM, "newBuffer", "(JI)L" + MappedObjectTransformer.jvmClassName(ByteBuffer.class) + ";");
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(3, 2);
                methodVisitor.visitEnd();
            }

            private void generateFieldGetter(String string2, FieldInfo fieldInfo) {
                MethodVisitor methodVisitor = super.visitMethod(9, MappedObjectTransformer.getterName(string2), "(L" + string + ";I)" + fieldInfo.type.getDescriptor(), null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(21, 1);
                methodVisitor.visitMethodInsn(182, string, MappedObjectTransformer.VIEWADDRESS_METHOD_NAME, "(I)J");
                MappedObjectTransformer.visitIntNode(methodVisitor, (int)fieldInfo.offset);
                methodVisitor.visitInsn(133);
                methodVisitor.visitInsn(97);
                methodVisitor.visitMethodInsn(184, MAPPED_HELPER_JVM, fieldInfo.getAccessType() + "get", "(J)" + fieldInfo.type.getDescriptor());
                methodVisitor.visitInsn(fieldInfo.type.getOpcode(172));
                methodVisitor.visitMaxs(3, 2);
                methodVisitor.visitEnd();
            }

            private void generateFieldSetter(String string2, FieldInfo fieldInfo) {
                MethodVisitor methodVisitor = super.visitMethod(9, MappedObjectTransformer.setterName(string2), "(L" + string + ";I" + fieldInfo.type.getDescriptor() + ")V", null, null);
                methodVisitor.visitCode();
                int n2 = 0;
                switch (fieldInfo.type.getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 21;
                        break;
                    }
                    case 6: {
                        n2 = 23;
                        break;
                    }
                    case 7: {
                        n2 = 22;
                        break;
                    }
                    case 8: {
                        n2 = 24;
                    }
                }
                methodVisitor.visitVarInsn(n2, 2);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(21, 1);
                methodVisitor.visitMethodInsn(182, string, MappedObjectTransformer.VIEWADDRESS_METHOD_NAME, "(I)J");
                MappedObjectTransformer.visitIntNode(methodVisitor, (int)fieldInfo.offset);
                methodVisitor.visitInsn(133);
                methodVisitor.visitInsn(97);
                methodVisitor.visitMethodInsn(184, MAPPED_HELPER_JVM, fieldInfo.getAccessType() + "put", "(" + fieldInfo.type.getDescriptor() + "J)V");
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(4, 4);
                methodVisitor.visitEnd();
            }
        };
    }

    static int transformMethodCall(InsnList insnList, int n2, Map<AbstractInsnNode, Frame<BasicValue>> map, MethodInsnNode methodInsnNode, MappedSubtypeInfo mappedSubtypeInfo, Map<Integer, MappedSubtypeInfo> map2) {
        switch (methodInsnNode.getOpcode()) {
            case 182: {
                if ("asArray".equals(methodInsnNode.name) && methodInsnNode.desc.equals("()[L" + MAPPED_OBJECT_JVM + ";")) {
                    AbstractInsnNode abstractInsnNode = methodInsnNode.getNext();
                    MappedObjectTransformer.checkInsnAfterIsArray(abstractInsnNode, 192);
                    abstractInsnNode = abstractInsnNode.getNext();
                    MappedObjectTransformer.checkInsnAfterIsArray(abstractInsnNode, 58);
                    Frame<BasicValue> frame = map.get(abstractInsnNode);
                    String string = ((BasicValue)frame.getStack(frame.getStackSize() - 1)).getType().getElementType().getInternalName();
                    if (!methodInsnNode.owner.equals(string)) {
                        throw new ClassCastException("Source: " + methodInsnNode.owner + " - Target: " + string);
                    }
                    VarInsnNode varInsnNode = (VarInsnNode)abstractInsnNode;
                    map2.put(varInsnNode.var, mappedSubtypeInfo);
                    insnList.remove(methodInsnNode.getNext());
                    insnList.remove((AbstractInsnNode)methodInsnNode);
                }
                if ("dup".equals(methodInsnNode.name) && methodInsnNode.desc.equals("()L" + MAPPED_OBJECT_JVM + ";")) {
                    n2 = MappedObjectTransformer.replace(insnList, n2, (AbstractInsnNode)methodInsnNode, MappedObjectTransformer.generateDupInstructions(methodInsnNode));
                    break;
                }
                if ("slice".equals(methodInsnNode.name) && methodInsnNode.desc.equals("()L" + MAPPED_OBJECT_JVM + ";")) {
                    n2 = MappedObjectTransformer.replace(insnList, n2, (AbstractInsnNode)methodInsnNode, MappedObjectTransformer.generateSliceInstructions(methodInsnNode));
                    break;
                }
                if ("runViewConstructor".equals(methodInsnNode.name) && "()V".equals(methodInsnNode.desc)) {
                    n2 = MappedObjectTransformer.replace(insnList, n2, (AbstractInsnNode)methodInsnNode, MappedObjectTransformer.generateRunViewConstructorInstructions(methodInsnNode));
                    break;
                }
                if ("copyTo".equals(methodInsnNode.name) && methodInsnNode.desc.equals("(L" + MAPPED_OBJECT_JVM + ";)V")) {
                    n2 = MappedObjectTransformer.replace(insnList, n2, (AbstractInsnNode)methodInsnNode, MappedObjectTransformer.generateCopyToInstructions(mappedSubtypeInfo));
                    break;
                }
                if (!"copyRange".equals(methodInsnNode.name) || !methodInsnNode.desc.equals("(L" + MAPPED_OBJECT_JVM + ";I)V")) break;
                n2 = MappedObjectTransformer.replace(insnList, n2, (AbstractInsnNode)methodInsnNode, MappedObjectTransformer.generateCopyRangeInstructions(mappedSubtypeInfo));
                break;
            }
            case 183: {
                if (!methodInsnNode.owner.equals(MAPPED_OBJECT_JVM) || !"<init>".equals(methodInsnNode.name) || !"()V".equals(methodInsnNode.desc)) break;
                insnList.remove(methodInsnNode.getPrevious());
                insnList.remove((AbstractInsnNode)methodInsnNode);
                n2 -= 2;
                break;
            }
            case 184: {
                boolean bl2;
                boolean bl3 = "map".equals(methodInsnNode.name) && methodInsnNode.desc.equals("(JI)L" + MAPPED_OBJECT_JVM + ";");
                boolean bl4 = "map".equals(methodInsnNode.name) && methodInsnNode.desc.equals("(Ljava/nio/ByteBuffer;)L" + MAPPED_OBJECT_JVM + ";");
                boolean bl5 = bl2 = "malloc".equals(methodInsnNode.name) && methodInsnNode.desc.equals("(I)L" + MAPPED_OBJECT_JVM + ";");
                if (!bl3 && !bl4 && !bl2) break;
                n2 = MappedObjectTransformer.replace(insnList, n2, (AbstractInsnNode)methodInsnNode, MappedObjectTransformer.generateMapInstructions(mappedSubtypeInfo, methodInsnNode.owner, bl3, bl2));
            }
        }
        return n2;
    }

    private static InsnList generateCopyRangeInstructions(MappedSubtypeInfo mappedSubtypeInfo) {
        InsnList insnList = new InsnList();
        insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.sizeof));
        insnList.add((AbstractInsnNode)new InsnNode(104));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "copy", "(L" + MAPPED_OBJECT_JVM + ";L" + MAPPED_OBJECT_JVM + ";I)V"));
        return insnList;
    }

    private static InsnList generateCopyToInstructions(MappedSubtypeInfo mappedSubtypeInfo) {
        InsnList insnList = new InsnList();
        insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.sizeof - mappedSubtypeInfo.padding));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "copy", "(L" + MAPPED_OBJECT_JVM + ";L" + MAPPED_OBJECT_JVM + ";I)V"));
        return insnList;
    }

    private static InsnList generateRunViewConstructorInstructions(MethodInsnNode methodInsnNode) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, methodInsnNode.owner, VIEW_CONSTRUCTOR_NAME, "()V"));
        return insnList;
    }

    private static InsnList generateSliceInstructions(MethodInsnNode methodInsnNode) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new TypeInsnNode(187, methodInsnNode.owner));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new MethodInsnNode(183, methodInsnNode.owner, "<init>", "()V"));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "slice", "(L" + MAPPED_OBJECT_JVM + ";L" + MAPPED_OBJECT_JVM + ";)L" + MAPPED_OBJECT_JVM + ";"));
        return insnList;
    }

    private static InsnList generateDupInstructions(MethodInsnNode methodInsnNode) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new TypeInsnNode(187, methodInsnNode.owner));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new MethodInsnNode(183, methodInsnNode.owner, "<init>", "()V"));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "dup", "(L" + MAPPED_OBJECT_JVM + ";L" + MAPPED_OBJECT_JVM + ";)L" + MAPPED_OBJECT_JVM + ";"));
        return insnList;
    }

    private static InsnList generateMapInstructions(MappedSubtypeInfo mappedSubtypeInfo, String string, boolean bl2, boolean bl3) {
        InsnList insnList = new InsnList();
        if (bl3) {
            insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.sizeof));
            insnList.add((AbstractInsnNode)new InsnNode(104));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, mappedSubtypeInfo.cacheLinePadded ? MappedObjectTransformer.jvmClassName(CacheUtil.class) : MappedObjectTransformer.jvmClassName(BufferUtils.class), "createByteBuffer", "(I)L" + MappedObjectTransformer.jvmClassName(ByteBuffer.class) + ";"));
        } else if (bl2) {
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "newBuffer", "(JI)L" + MappedObjectTransformer.jvmClassName(ByteBuffer.class) + ";"));
        }
        insnList.add((AbstractInsnNode)new TypeInsnNode(187, string));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new MethodInsnNode(183, string, "<init>", "()V"));
        insnList.add((AbstractInsnNode)new InsnNode(90));
        insnList.add((AbstractInsnNode)new InsnNode(95));
        insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.align));
        insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.sizeof));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "setup", "(L" + MAPPED_OBJECT_JVM + ";Ljava/nio/ByteBuffer;II)V"));
        return insnList;
    }

    static InsnList transformFieldAccess(FieldInsnNode fieldInsnNode) {
        MappedSubtypeInfo mappedSubtypeInfo = className_to_subtype.get(fieldInsnNode.owner);
        if (mappedSubtypeInfo == null) {
            if ("view".equals(fieldInsnNode.name) && fieldInsnNode.owner.startsWith(MAPPEDSET_PREFIX)) {
                return MappedObjectTransformer.generateSetViewInstructions(fieldInsnNode);
            }
            return null;
        }
        if ("SIZEOF".equals(fieldInsnNode.name)) {
            return MappedObjectTransformer.generateSIZEOFInstructions(fieldInsnNode, mappedSubtypeInfo);
        }
        if ("view".equals(fieldInsnNode.name)) {
            return MappedObjectTransformer.generateViewInstructions(fieldInsnNode, mappedSubtypeInfo);
        }
        if ("baseAddress".equals(fieldInsnNode.name) || "viewAddress".equals(fieldInsnNode.name)) {
            return MappedObjectTransformer.generateAddressInstructions(fieldInsnNode);
        }
        FieldInfo fieldInfo = mappedSubtypeInfo.fields.get(fieldInsnNode.name);
        if (fieldInfo == null) {
            return null;
        }
        if (fieldInsnNode.desc.equals("L" + MappedObjectTransformer.jvmClassName(ByteBuffer.class) + ";")) {
            return MappedObjectTransformer.generateByteBufferInstructions(fieldInsnNode, mappedSubtypeInfo, fieldInfo.offset);
        }
        return MappedObjectTransformer.generateFieldInstructions(fieldInsnNode, fieldInfo);
    }

    private static InsnList generateSetViewInstructions(FieldInsnNode fieldInsnNode) {
        if (fieldInsnNode.getOpcode() == 180) {
            MappedObjectTransformer.throwAccessErrorOnReadOnlyField(fieldInsnNode.owner, fieldInsnNode.name);
        }
        if (fieldInsnNode.getOpcode() != 181) {
            throw new InternalError();
        }
        InsnList insnList = new InsnList();
        if (MAPPED_SET2_JVM.equals(fieldInsnNode.owner)) {
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "put_views", "(L" + MAPPED_SET2_JVM + ";I)V"));
        } else if (MAPPED_SET3_JVM.equals(fieldInsnNode.owner)) {
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "put_views", "(L" + MAPPED_SET3_JVM + ";I)V"));
        } else if (MAPPED_SET4_JVM.equals(fieldInsnNode.owner)) {
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "put_views", "(L" + MAPPED_SET4_JVM + ";I)V"));
        } else {
            throw new InternalError();
        }
        return insnList;
    }

    private static InsnList generateSIZEOFInstructions(FieldInsnNode fieldInsnNode, MappedSubtypeInfo mappedSubtypeInfo) {
        if (!"I".equals(fieldInsnNode.desc)) {
            throw new InternalError();
        }
        InsnList insnList = new InsnList();
        if (fieldInsnNode.getOpcode() == 178) {
            insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.sizeof));
            return insnList;
        }
        if (fieldInsnNode.getOpcode() == 179) {
            MappedObjectTransformer.throwAccessErrorOnReadOnlyField(fieldInsnNode.owner, fieldInsnNode.name);
        }
        throw new InternalError();
    }

    private static InsnList generateViewInstructions(FieldInsnNode fieldInsnNode, MappedSubtypeInfo mappedSubtypeInfo) {
        if (!"I".equals(fieldInsnNode.desc)) {
            throw new InternalError();
        }
        InsnList insnList = new InsnList();
        if (fieldInsnNode.getOpcode() == 180) {
            if (mappedSubtypeInfo.sizeof_shift != 0) {
                insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.sizeof_shift));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "get_view_shift", "(L" + MAPPED_OBJECT_JVM + ";I)I"));
            } else {
                insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.sizeof));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "get_view", "(L" + MAPPED_OBJECT_JVM + ";I)I"));
            }
            return insnList;
        }
        if (fieldInsnNode.getOpcode() == 181) {
            if (mappedSubtypeInfo.sizeof_shift != 0) {
                insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.sizeof_shift));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "put_view_shift", "(L" + MAPPED_OBJECT_JVM + ";II)V"));
            } else {
                insnList.add(MappedObjectTransformer.getIntNode(mappedSubtypeInfo.sizeof));
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "put_view", "(L" + MAPPED_OBJECT_JVM + ";II)V"));
            }
            return insnList;
        }
        throw new InternalError();
    }

    private static InsnList generateAddressInstructions(FieldInsnNode fieldInsnNode) {
        if (!"J".equals(fieldInsnNode.desc)) {
            throw new IllegalStateException();
        }
        if (fieldInsnNode.getOpcode() == 180) {
            return null;
        }
        if (fieldInsnNode.getOpcode() == 181) {
            MappedObjectTransformer.throwAccessErrorOnReadOnlyField(fieldInsnNode.owner, fieldInsnNode.name);
        }
        throw new InternalError();
    }

    private static InsnList generateByteBufferInstructions(FieldInsnNode fieldInsnNode, MappedSubtypeInfo mappedSubtypeInfo, long l2) {
        if (fieldInsnNode.getOpcode() == 181) {
            MappedObjectTransformer.throwAccessErrorOnReadOnlyField(fieldInsnNode.owner, fieldInsnNode.name);
        }
        if (fieldInsnNode.getOpcode() == 180) {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new FieldInsnNode(180, mappedSubtypeInfo.className, "viewAddress", "J"));
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)l2));
            insnList.add((AbstractInsnNode)new InsnNode(97));
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)mappedSubtypeInfo.fields.get((Object)fieldInsnNode.name).length));
            insnList.add((AbstractInsnNode)new InsnNode(136));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, "newBuffer", "(JI)L" + MappedObjectTransformer.jvmClassName(ByteBuffer.class) + ";"));
            return insnList;
        }
        throw new InternalError();
    }

    private static InsnList generateFieldInstructions(FieldInsnNode fieldInsnNode, FieldInfo fieldInfo) {
        InsnList insnList = new InsnList();
        if (fieldInsnNode.getOpcode() == 181) {
            insnList.add(MappedObjectTransformer.getIntNode((int)fieldInfo.offset));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, fieldInfo.getAccessType() + "put", "(L" + MAPPED_OBJECT_JVM + ";" + fieldInsnNode.desc + "I)V"));
            return insnList;
        }
        if (fieldInsnNode.getOpcode() == 180) {
            insnList.add(MappedObjectTransformer.getIntNode((int)fieldInfo.offset));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, MAPPED_HELPER_JVM, fieldInfo.getAccessType() + "get", "(L" + MAPPED_OBJECT_JVM + ";I)" + fieldInsnNode.desc));
            return insnList;
        }
        throw new InternalError();
    }

    static int transformArrayAccess(InsnList insnList, int n2, Map<AbstractInsnNode, Frame<BasicValue>> map, VarInsnNode varInsnNode, MappedSubtypeInfo mappedSubtypeInfo, int n3) {
        int n4 = map.get(varInsnNode).getStackSize() + 1;
        VarInsnNode varInsnNode2 = varInsnNode;
        while (true) {
            if ((varInsnNode2 = varInsnNode2.getNext()) == null) {
                throw new InternalError();
            }
            Frame<BasicValue> frame = map.get(varInsnNode2);
            if (frame == null) continue;
            int n5 = frame.getStackSize();
            if (n5 == n4 + 1 && varInsnNode2.getOpcode() == 50) {
                VarInsnNode varInsnNode3 = varInsnNode2;
                while ((varInsnNode2 = varInsnNode2.getNext()) != null) {
                    FieldInsnNode fieldInsnNode;
                    frame = map.get(varInsnNode2);
                    if (frame == null) continue;
                    n5 = frame.getStackSize();
                    if (n5 == n4 + 1 && varInsnNode2.getOpcode() == 181) {
                        fieldInsnNode = (FieldInsnNode)varInsnNode2;
                        insnList.insert((AbstractInsnNode)varInsnNode2, (AbstractInsnNode)new MethodInsnNode(184, mappedSubtypeInfo.className, MappedObjectTransformer.setterName(fieldInsnNode.name), "(L" + mappedSubtypeInfo.className + ";I" + fieldInsnNode.desc + ")V"));
                        insnList.remove((AbstractInsnNode)varInsnNode2);
                        break;
                    }
                    if (n5 == n4 && varInsnNode2.getOpcode() == 180) {
                        fieldInsnNode = (FieldInsnNode)varInsnNode2;
                        insnList.insert((AbstractInsnNode)varInsnNode2, (AbstractInsnNode)new MethodInsnNode(184, mappedSubtypeInfo.className, MappedObjectTransformer.getterName(fieldInsnNode.name), "(L" + mappedSubtypeInfo.className + ";I)" + fieldInsnNode.desc));
                        insnList.remove((AbstractInsnNode)varInsnNode2);
                        break;
                    }
                    if (n5 == n4 && varInsnNode2.getOpcode() == 89 && varInsnNode2.getNext().getOpcode() == 180) {
                        fieldInsnNode = (FieldInsnNode)varInsnNode2.getNext();
                        MethodInsnNode methodInsnNode = new MethodInsnNode(184, mappedSubtypeInfo.className, MappedObjectTransformer.getterName(fieldInsnNode.name), "(L" + mappedSubtypeInfo.className + ";I)" + fieldInsnNode.desc);
                        insnList.insert((AbstractInsnNode)varInsnNode2, (AbstractInsnNode)new InsnNode(92));
                        insnList.insert(varInsnNode2.getNext(), (AbstractInsnNode)methodInsnNode);
                        insnList.remove((AbstractInsnNode)varInsnNode2);
                        insnList.remove((AbstractInsnNode)fieldInsnNode);
                        varInsnNode2 = methodInsnNode;
                        continue;
                    }
                    if (n5 >= n4) continue;
                    throw new ClassFormatError("Invalid " + mappedSubtypeInfo.className + " view array usage detected: " + MappedObjectTransformer.getOpcodeName((AbstractInsnNode)varInsnNode2));
                }
                insnList.remove((AbstractInsnNode)varInsnNode3);
                return n2;
            }
            if (n5 == n4 && varInsnNode2.getOpcode() == 190) {
                if (LWJGLUtil.DEBUG && varInsnNode.getNext() != varInsnNode2) {
                    throw new InternalError();
                }
                insnList.remove((AbstractInsnNode)varInsnNode2);
                varInsnNode.var = n3;
                insnList.insert((AbstractInsnNode)varInsnNode, (AbstractInsnNode)new MethodInsnNode(182, mappedSubtypeInfo.className, CAPACITY_METHOD_NAME, "()I"));
                return n2 + 1;
            }
            if (n5 < n4) break;
        }
        throw new ClassFormatError("Invalid " + mappedSubtypeInfo.className + " view array usage detected: " + MappedObjectTransformer.getOpcodeName((AbstractInsnNode)varInsnNode2));
    }

    private static void getClassEnums(Class clazz, Map<Integer, String> map, String ... stringArray) {
        try {
            block2: for (Field field : clazz.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Integer.TYPE) continue;
                for (String string : stringArray) {
                    if (field.getName().startsWith(string)) continue block2;
                }
                if (map.put((Integer)field.get(null), field.getName()) == null) continue;
                throw new IllegalStateException();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static String getOpcodeName(AbstractInsnNode abstractInsnNode) {
        String string = OPCODE_TO_NAME.get(abstractInsnNode.getOpcode());
        return INSNTYPE_TO_NAME.get(abstractInsnNode.getType()) + ": " + abstractInsnNode.getOpcode() + (string == null ? "" : " [" + OPCODE_TO_NAME.get(abstractInsnNode.getOpcode()) + "]");
    }

    static String jvmClassName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    static String getterName(String string) {
        return "get$" + Character.toUpperCase(string.charAt(0)) + string.substring(1) + "$LWJGL";
    }

    static String setterName(String string) {
        return "set$" + Character.toUpperCase(string.charAt(0)) + string.substring(1) + "$LWJGL";
    }

    private static void checkInsnAfterIsArray(AbstractInsnNode abstractInsnNode, int n2) {
        if (abstractInsnNode == null) {
            throw new ClassFormatError("Unexpected end of instructions after .asArray() method.");
        }
        if (abstractInsnNode.getOpcode() != n2) {
            throw new ClassFormatError("The result of .asArray() must be stored to a local variable. Found: " + MappedObjectTransformer.getOpcodeName(abstractInsnNode));
        }
    }

    static AbstractInsnNode getIntNode(int n2) {
        if (n2 <= 5 && -1 <= n2) {
            return new InsnNode(2 + n2 + 1);
        }
        if (n2 >= -128 && n2 <= 127) {
            return new IntInsnNode(16, n2);
        }
        if (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE) {
            return new IntInsnNode(17, n2);
        }
        return new LdcInsnNode((Object)n2);
    }

    static void visitIntNode(MethodVisitor methodVisitor, int n2) {
        if (n2 <= 5 && -1 <= n2) {
            methodVisitor.visitInsn(2 + n2 + 1);
        } else if (n2 >= -128 && n2 <= 127) {
            methodVisitor.visitIntInsn(16, n2);
        } else if (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE) {
            methodVisitor.visitIntInsn(17, n2);
        } else {
            methodVisitor.visitLdcInsn((Object)n2);
        }
    }

    static int replace(InsnList insnList, int n2, AbstractInsnNode abstractInsnNode, InsnList insnList2) {
        int n3 = insnList2.size();
        insnList.insert(abstractInsnNode, insnList2);
        insnList.remove(abstractInsnNode);
        return n2 + (n3 - 1);
    }

    private static void throwAccessErrorOnReadOnlyField(String string, String string2) {
        throw new IllegalAccessError("The " + string + "." + string2 + " field is final.");
    }

    private static void printBytecode(byte[] byArray) {
        StringWriter stringWriter = new StringWriter();
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor((ClassVisitor)new ClassWriter(0), new PrintWriter(stringWriter));
        new ClassReader(byArray).accept((ClassVisitor)traceClassVisitor, 0);
        String string = stringWriter.toString();
        LWJGLUtil.log(string);
    }

    static {
        MAPPED_OBJECT_JVM = MappedObjectTransformer.jvmClassName(MappedObject.class);
        MAPPED_HELPER_JVM = MappedObjectTransformer.jvmClassName(MappedHelper.class);
        MAPPEDSET_PREFIX = MappedObjectTransformer.jvmClassName(MappedSet.class);
        MAPPED_SET2_JVM = MappedObjectTransformer.jvmClassName(MappedSet2.class);
        MAPPED_SET3_JVM = MappedObjectTransformer.jvmClassName(MappedSet3.class);
        MAPPED_SET4_JVM = MappedObjectTransformer.jvmClassName(MappedSet4.class);
        CACHE_LINE_PAD_JVM = "L" + MappedObjectTransformer.jvmClassName(CacheLinePad.class) + ";";
        OPCODE_TO_NAME = new HashMap<Integer, String>();
        INSNTYPE_TO_NAME = new HashMap<Integer, String>();
        MappedObjectTransformer.getClassEnums(Opcodes.class, OPCODE_TO_NAME, "V1_", "ACC_", "T_", "F_", "MH_");
        MappedObjectTransformer.getClassEnums(AbstractInsnNode.class, INSNTYPE_TO_NAME, new String[0]);
        className_to_subtype = new HashMap<String, MappedSubtypeInfo>();
        className_to_subtype.put(MAPPED_OBJECT_JVM, new MappedSubtypeInfo(MAPPED_OBJECT_JVM, null, -1, -1, -1, false));
        String string = System.getProperty("java.vm.name");
        if (string != null && !string.contains("Server")) {
            System.err.println("Warning: " + MappedObject.class.getSimpleName() + "s have inferiour performance on Client VMs, please consider switching to a Server VM.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MappedSubtypeInfo {
        final String className;
        final int sizeof;
        final int sizeof_shift;
        final int align;
        final int padding;
        final boolean cacheLinePadded;
        final Map<String, FieldInfo> fields;

        MappedSubtypeInfo(String string, Map<String, FieldInfo> map, int n2, int n3, int n4, boolean bl2) {
            this.className = string;
            this.sizeof = n2;
            this.sizeof_shift = (n2 - 1 & n2) == 0 ? MappedSubtypeInfo.getPoT(n2) : 0;
            this.align = n3;
            this.padding = n4;
            this.cacheLinePadded = bl2;
            this.fields = map;
        }

        private static int getPoT(int n2) {
            int n3 = -1;
            while (n2 > 0) {
                ++n3;
                n2 >>= 1;
            }
            return n3;
        }
    }

    static class FieldInfo {
        final long offset;
        final long length;
        final long lengthPadded;
        final Type type;
        final boolean isVolatile;
        final boolean isPointer;

        FieldInfo(long l2, long l3, long l4, Type type, boolean bl2, boolean bl3) {
            this.offset = l2;
            this.length = l3;
            this.lengthPadded = l4;
            this.type = type;
            this.isVolatile = bl2;
            this.isPointer = bl3;
        }

        String getAccessType() {
            return this.isPointer ? "a" : this.type.getDescriptor().toLowerCase() + (this.isVolatile ? "v" : "");
        }
    }

    static class TransformationAdapter
    extends ClassAdapter {
        final String className;
        boolean transformed;

        TransformationAdapter(ClassVisitor classVisitor, String string) {
            super(classVisitor);
            this.className = string;
        }

        public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
            MappedSubtypeInfo mappedSubtypeInfo = className_to_subtype.get(this.className);
            if (mappedSubtypeInfo != null && mappedSubtypeInfo.fields.containsKey(string)) {
                if (PRINT_ACTIVITY) {
                    LWJGLUtil.log(MappedObjectTransformer.class.getSimpleName() + ": discarding field: " + this.className + "." + string + ":" + string2);
                }
                return null;
            }
            if ((n2 & 8) == 0) {
                return new FieldNode(n2, string, string2, string3, object){

                    public void visitEnd() {
                        if (this.visibleAnnotations == null) {
                            this.accept(TransformationAdapter.this.cv);
                            return;
                        }
                        boolean bl2 = false;
                        boolean bl3 = false;
                        int n2 = 0;
                        for (AnnotationNode annotationNode : this.visibleAnnotations) {
                            if (!CACHE_LINE_PAD_JVM.equals(annotationNode.desc)) continue;
                            if ("J".equals(this.desc) || "D".equals(this.desc)) {
                                n2 = 8;
                            } else if ("I".equals(this.desc) || "F".equals(this.desc)) {
                                n2 = 4;
                            } else if ("S".equals(this.desc) || "C".equals(this.desc)) {
                                n2 = 2;
                            } else if ("B".equals(this.desc) || "Z".equals(this.desc)) {
                                n2 = 1;
                            } else {
                                throw new ClassFormatError("The @CacheLinePad annotation cannot be used on non-primitive fields: " + TransformationAdapter.this.className + "." + this.name);
                            }
                            TransformationAdapter.this.transformed = true;
                            bl3 = true;
                            if (annotationNode.values == null) break;
                            for (int i2 = 0; i2 < annotationNode.values.size(); i2 += 2) {
                                boolean bl4 = annotationNode.values.get(i2 + 1).equals(Boolean.TRUE);
                                if ("before".equals(annotationNode.values.get(i2))) {
                                    bl2 = bl4;
                                    continue;
                                }
                                bl3 = bl4;
                            }
                        }
                        if (bl2) {
                            int n3;
                            for (int i3 = n3 = CacheUtil.getCacheLineSize() / n2 - 1; i3 >= 1; --i3) {
                                TransformationAdapter.this.cv.visitField(this.access | 1 | 0x1000, this.name + "$PAD_" + i3, this.desc, this.signature, null);
                            }
                        }
                        this.accept(TransformationAdapter.this.cv);
                        if (bl3) {
                            int n4 = CacheUtil.getCacheLineSize() / n2 - 1;
                            for (int i4 = 1; i4 <= n4; ++i4) {
                                TransformationAdapter.this.cv.visitField(this.access | 1 | 0x1000, this.name + "$PAD" + i4, this.desc, this.signature, null);
                            }
                        }
                    }
                };
            }
            return super.visitField(n2, string, string2, string3, object);
        }

        public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
            MappedSubtypeInfo mappedSubtypeInfo;
            if ("<init>".equals(string) && (mappedSubtypeInfo = className_to_subtype.get(this.className)) != null) {
                if (!"()V".equals(string2)) {
                    throw new ClassFormatError(this.className + " can only have a default constructor, found: " + string2);
                }
                MethodVisitor methodVisitor = super.visitMethod(n2, string, string2, string3, stringArray);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(183, MAPPED_OBJECT_JVM, "<init>", "()V");
                methodVisitor.visitInsn(177);
                methodVisitor.visitMaxs(0, 0);
                string = MappedObjectTransformer.VIEW_CONSTRUCTOR_NAME;
            }
            mappedSubtypeInfo = super.visitMethod(n2, string, string2, string3, stringArray);
            return new MethodNode(n2, string, string2, string3, stringArray, (MethodVisitor)mappedSubtypeInfo){
                boolean needsTransformation;
                final /* synthetic */ MethodVisitor val$mv;
                {
                    this.val$mv = methodVisitor;
                    super(n2, string, string2, string3, stringArray);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visitMaxs(int n2, int n3) {
                    try {
                        is_currently_computing_frames = true;
                        super.visitMaxs(n2, n3);
                    }
                    finally {
                        is_currently_computing_frames = false;
                    }
                }

                public void visitFieldInsn(int n2, String string, String string2, String string3) {
                    if (className_to_subtype.containsKey(string) || string.startsWith(MAPPEDSET_PREFIX)) {
                        this.needsTransformation = true;
                    }
                    super.visitFieldInsn(n2, string, string2, string3);
                }

                public void visitMethodInsn(int n2, String string, String string2, String string3) {
                    if (className_to_subtype.containsKey(string)) {
                        this.needsTransformation = true;
                    }
                    super.visitMethodInsn(n2, string, string2, string3);
                }

                public void visitEnd() {
                    if (this.needsTransformation) {
                        TransformationAdapter.this.transformed = true;
                        try {
                            this.transformMethod(this.analyse());
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                    this.accept(this.val$mv);
                }

                private Frame<BasicValue>[] analyse() {
                    Analyzer analyzer = new Analyzer((Interpreter)new SimpleVerifier());
                    analyzer.analyze(TransformationAdapter.this.className, (MethodNode)this);
                    return analyzer.getFrames();
                }

                private void transformMethod(Frame<BasicValue>[] frameArray) {
                    int n2;
                    InsnList insnList = this.instructions;
                    HashMap<Integer, MappedSubtypeInfo> hashMap = new HashMap<Integer, MappedSubtypeInfo>();
                    HashMap<AbstractInsnNode, Frame<BasicValue>> hashMap2 = new HashMap<AbstractInsnNode, Frame<BasicValue>>();
                    for (n2 = 0; n2 < frameArray.length; ++n2) {
                        hashMap2.put(insnList.get(n2), frameArray[n2]);
                    }
                    block6: for (n2 = 0; n2 < insnList.size(); ++n2) {
                        AbstractInsnNode abstractInsnNode = insnList.get(n2);
                        switch (abstractInsnNode.getType()) {
                            case 2: {
                                if (abstractInsnNode.getOpcode() != 25) continue block6;
                                FieldInsnNode fieldInsnNode = (VarInsnNode)abstractInsnNode;
                                Object object = (MappedSubtypeInfo)hashMap.get(fieldInsnNode.var);
                                if (object == null) continue block6;
                                n2 = MappedObjectTransformer.transformArrayAccess(insnList, n2, hashMap2, (VarInsnNode)fieldInsnNode, (MappedSubtypeInfo)object, fieldInsnNode.var);
                                continue block6;
                            }
                            case 4: {
                                FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
                                Object object = MappedObjectTransformer.transformFieldAccess(fieldInsnNode);
                                if (object == null) continue block6;
                                n2 = MappedObjectTransformer.replace(insnList, n2, abstractInsnNode, object);
                                continue block6;
                            }
                            case 5: {
                                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                                MappedSubtypeInfo mappedSubtypeInfo = className_to_subtype.get(methodInsnNode.owner);
                                if (mappedSubtypeInfo == null) continue block6;
                                n2 = MappedObjectTransformer.transformMethodCall(insnList, n2, hashMap2, methodInsnNode, mappedSubtypeInfo, hashMap);
                            }
                        }
                    }
                }
            };
        }
    }
}

