/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.mapped;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.util.mapped.CacheUtil;
import org.lwjgl.util.mapped.MappedObject;
import org.lwjgl.util.mapped.MappedObjectTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedObjectClassLoader
extends URLClassLoader {
    static final String MAPPEDOBJECT_PACKAGE_PREFIX = MappedObjectClassLoader.class.getPackage().getName() + ".";
    static boolean FORKED;
    private static long total_time_transforming;

    public static boolean fork(Class<?> clazz, String[] stringArray) {
        if (FORKED) {
            return false;
        }
        FORKED = true;
        try {
            MappedObjectClassLoader mappedObjectClassLoader = new MappedObjectClassLoader(clazz);
            mappedObjectClassLoader.loadMappedObject();
            Class<?> clazz2 = mappedObjectClassLoader.loadClass(clazz.getName());
            Method method = clazz2.getMethod("main", String[].class);
            method.invoke(null, new Object[]{stringArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), invocationTargetException.getCause());
        }
        catch (Throwable throwable) {
            throw new Error("failed to fork", throwable);
        }
        return true;
    }

    private MappedObjectClassLoader(Class<?> clazz) {
        super(((URLClassLoader)clazz.getClassLoader()).getURLs());
    }

    protected synchronized Class<?> loadMappedObject() {
        String string = MappedObject.class.getName();
        String string2 = string.replace('.', '/');
        byte[] byArray = MappedObjectClassLoader.readStream(this.getResourceAsStream(string2.concat(".class")));
        long l2 = System.nanoTime();
        byArray = MappedObjectTransformer.transformMappedObject(byArray);
        long l3 = System.nanoTime();
        total_time_transforming += l3 - l2;
        if (MappedObjectTransformer.PRINT_ACTIVITY) {
            MappedObjectClassLoader.printActivity(string2, l2, l3);
        }
        Class<?> clazz = super.defineClass(string, byArray, 0, byArray.length);
        this.resolveClass(clazz);
        return clazz;
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl2) {
        if (string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("sun.") || string.startsWith("sunw.") || string.startsWith("org.objectweb.asm.")) {
            return super.loadClass(string, bl2);
        }
        String string2 = string.replace('.', '/');
        boolean bl3 = string.startsWith(MAPPEDOBJECT_PACKAGE_PREFIX);
        if (bl3 && (string.equals(MappedObjectClassLoader.class.getName()) || string.equals(MappedObjectTransformer.class.getName()) || string.equals(CacheUtil.class.getName()))) {
            return super.loadClass(string, bl2);
        }
        byte[] byArray = MappedObjectClassLoader.readStream(this.getResourceAsStream(string2.concat(".class")));
        if (!bl3 || string.substring(MAPPEDOBJECT_PACKAGE_PREFIX.length()).indexOf(46) != -1) {
            long l2 = System.nanoTime();
            byte[] byArray2 = MappedObjectTransformer.transformMappedAPI(string2, byArray);
            long l3 = System.nanoTime();
            total_time_transforming += l3 - l2;
            if (byArray != byArray2) {
                byArray = byArray2;
                if (MappedObjectTransformer.PRINT_ACTIVITY) {
                    MappedObjectClassLoader.printActivity(string2, l2, l3);
                }
            }
        }
        Class<?> clazz = super.defineClass(string, byArray, 0, byArray.length);
        if (bl2) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private static void printActivity(String string, long l2, long l3) {
        StringBuilder stringBuilder = new StringBuilder(MappedObjectClassLoader.class.getSimpleName() + ": " + string);
        if (MappedObjectTransformer.PRINT_TIMING) {
            stringBuilder.append("\n\ttransforming took " + (l3 - l2) / 1000L + " micros (total: " + total_time_transforming / 1000L / 1000L + "ms)");
        }
        LWJGLUtil.log(stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readStream(InputStream inputStream) {
        byte[] byArray = new byte[256];
        int n2 = 0;
        try {
            while (true) {
                int n3;
                if (byArray.length == n2) {
                    byArray = MappedObjectClassLoader.copyOf(byArray, n2 * 2);
                }
                if ((n3 = inputStream.read(byArray, n2, byArray.length - n2)) == -1) {
                    break;
                }
                n2 += n3;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return MappedObjectClassLoader.copyOf(byArray, n2);
    }

    private static byte[] copyOf(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n2));
        return byArray2;
    }
}

