/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.mapped;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.util.mapped.MappedForeach;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappedObject {
    static final boolean CHECKS = LWJGLUtil.getPrivilegedBoolean("org.lwjgl.util.mapped.Checks");
    public long baseAddress;
    public long viewAddress;
    ByteBuffer preventGC;
    public static int SIZEOF = -1;
    public int view;

    protected MappedObject() {
    }

    protected final long getViewAddress(int n2) {
        throw new InternalError("type not registered");
    }

    public final void setViewAddress(long l2) {
        if (CHECKS) {
            this.checkAddress(l2);
        }
        this.viewAddress = l2;
    }

    final void checkAddress(long l2) {
        long l3 = MemoryUtil.getAddress0(this.preventGC);
        int n2 = (int)(l2 - l3);
        if (l2 < l3 || this.preventGC.capacity() < n2 + this.getSizeof()) {
            throw new IndexOutOfBoundsException(Integer.toString(n2 / this.getSizeof()));
        }
    }

    final void checkRange(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)this.preventGC.capacity() < this.viewAddress - MemoryUtil.getAddress0(this.preventGC) + (long)n2) {
            throw new BufferOverflowException();
        }
    }

    public final int getAlign() {
        throw new InternalError("type not registered");
    }

    public final int getSizeof() {
        throw new InternalError("type not registered");
    }

    public final int capacity() {
        throw new InternalError("type not registered");
    }

    public static <T extends MappedObject> T map(ByteBuffer byteBuffer) {
        throw new InternalError("type not registered");
    }

    public static <T extends MappedObject> T map(long l2, int n2) {
        throw new InternalError("type not registered");
    }

    public static <T extends MappedObject> T malloc(int n2) {
        throw new InternalError("type not registered");
    }

    public final <T extends MappedObject> T dup() {
        throw new InternalError("type not registered");
    }

    public final <T extends MappedObject> T slice() {
        throw new InternalError("type not registered");
    }

    public final void runViewConstructor() {
        throw new InternalError("type not registered");
    }

    public final void next() {
        throw new InternalError("type not registered");
    }

    public final <T extends MappedObject> void copyTo(T t2) {
        throw new InternalError("type not registered");
    }

    public final <T extends MappedObject> void copyRange(T t2, int n2) {
        throw new InternalError("type not registered");
    }

    public static <T extends MappedObject> Iterable<T> foreach(T t2) {
        return MappedObject.foreach(t2, t2.capacity());
    }

    public static <T extends MappedObject> Iterable<T> foreach(T t2, int n2) {
        return new MappedForeach<T>(t2, n2);
    }

    public final <T extends MappedObject> T[] asArray() {
        throw new InternalError("type not registered");
    }

    public final ByteBuffer backingByteBuffer() {
        return this.preventGC;
    }
}

