/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.mapped;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.util.mapped.MappedObject;
import org.lwjgl.util.mapped.MappedObjectUnsafe;
import org.lwjgl.util.mapped.MappedSet2;
import org.lwjgl.util.mapped.MappedSet3;
import org.lwjgl.util.mapped.MappedSet4;

public class MappedHelper {
    public static void setup(MappedObject mappedObject, ByteBuffer byteBuffer, int n2, int n3) {
        if (LWJGLUtil.CHECKS && mappedObject.baseAddress != 0L) {
            throw new IllegalStateException("this method should not be called by user-code");
        }
        if (LWJGLUtil.CHECKS && !byteBuffer.isDirect()) {
            throw new IllegalArgumentException("bytebuffer must be direct");
        }
        mappedObject.preventGC = byteBuffer;
        if (LWJGLUtil.CHECKS && n2 <= 0) {
            throw new IllegalArgumentException("invalid alignment");
        }
        if (LWJGLUtil.CHECKS && (n3 <= 0 || n3 % n2 != 0)) {
            throw new IllegalStateException("sizeof not a multiple of alignment");
        }
        long l2 = MemoryUtil.getAddress(byteBuffer);
        if (LWJGLUtil.CHECKS && l2 % (long)n2 != 0L) {
            throw new IllegalStateException("buffer address not aligned on " + n2 + " bytes");
        }
        mappedObject.baseAddress = mappedObject.viewAddress = l2;
    }

    public static void checkAddress(long l2, MappedObject mappedObject) {
        mappedObject.checkAddress(l2);
    }

    public static void put_views(MappedSet2 mappedSet2, int n2) {
        mappedSet2.view(n2);
    }

    public static void put_views(MappedSet3 mappedSet3, int n2) {
        mappedSet3.view(n2);
    }

    public static void put_views(MappedSet4 mappedSet4, int n2) {
        mappedSet4.view(n2);
    }

    public static void put_view(MappedObject mappedObject, int n2, int n3) {
        mappedObject.setViewAddress(mappedObject.baseAddress + (long)(n2 * n3));
    }

    public static int get_view(MappedObject mappedObject, int n2) {
        return (int)(mappedObject.viewAddress - mappedObject.baseAddress) / n2;
    }

    public static void put_view_shift(MappedObject mappedObject, int n2, int n3) {
        mappedObject.setViewAddress(mappedObject.baseAddress + (long)(n2 << n3));
    }

    public static int get_view_shift(MappedObject mappedObject, int n2) {
        return (int)(mappedObject.viewAddress - mappedObject.baseAddress) >> n2;
    }

    public static void put_view_next(MappedObject mappedObject, int n2) {
        mappedObject.setViewAddress(mappedObject.viewAddress + (long)n2);
    }

    public static MappedObject dup(MappedObject mappedObject, MappedObject mappedObject2) {
        mappedObject2.baseAddress = mappedObject.baseAddress;
        mappedObject2.viewAddress = mappedObject.viewAddress;
        mappedObject2.preventGC = mappedObject.preventGC;
        return mappedObject2;
    }

    public static MappedObject slice(MappedObject mappedObject, MappedObject mappedObject2) {
        mappedObject2.baseAddress = mappedObject.viewAddress;
        mappedObject2.viewAddress = mappedObject.viewAddress;
        mappedObject2.preventGC = mappedObject.preventGC;
        return mappedObject2;
    }

    public static void copy(MappedObject mappedObject, MappedObject mappedObject2, int n2) {
        if (MappedObject.CHECKS) {
            mappedObject.checkRange(n2);
            mappedObject2.checkRange(n2);
        }
        MappedObjectUnsafe.INSTANCE.copyMemory(mappedObject.viewAddress, mappedObject2.viewAddress, n2);
    }

    public static ByteBuffer newBuffer(long l2, int n2) {
        return MappedObjectUnsafe.newBuffer(l2, n2);
    }

    public static void bput(byte by2, long l2) {
        MappedObjectUnsafe.INSTANCE.putByte(l2, by2);
    }

    public static void bput(MappedObject mappedObject, byte by2, int n2) {
        MappedObjectUnsafe.INSTANCE.putByte(mappedObject.viewAddress + (long)n2, by2);
    }

    public static byte bget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getByte(l2);
    }

    public static byte bget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getByte(mappedObject.viewAddress + (long)n2);
    }

    public static void bvput(byte by2, long l2) {
        MappedObjectUnsafe.INSTANCE.putByteVolatile(null, l2, by2);
    }

    public static void bvput(MappedObject mappedObject, byte by2, int n2) {
        MappedObjectUnsafe.INSTANCE.putByteVolatile(null, mappedObject.viewAddress + (long)n2, by2);
    }

    public static byte bvget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getByteVolatile(null, l2);
    }

    public static byte bvget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getByteVolatile(null, mappedObject.viewAddress + (long)n2);
    }

    public static void sput(short s2, long l2) {
        MappedObjectUnsafe.INSTANCE.putShort(l2, s2);
    }

    public static void sput(MappedObject mappedObject, short s2, int n2) {
        MappedObjectUnsafe.INSTANCE.putShort(mappedObject.viewAddress + (long)n2, s2);
    }

    public static short sget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getShort(l2);
    }

    public static short sget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getShort(mappedObject.viewAddress + (long)n2);
    }

    public static void svput(short s2, long l2) {
        MappedObjectUnsafe.INSTANCE.putShortVolatile(null, l2, s2);
    }

    public static void svput(MappedObject mappedObject, short s2, int n2) {
        MappedObjectUnsafe.INSTANCE.putShortVolatile(null, mappedObject.viewAddress + (long)n2, s2);
    }

    public static short svget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getShortVolatile(null, l2);
    }

    public static short svget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getShortVolatile(null, mappedObject.viewAddress + (long)n2);
    }

    public static void cput(char c2, long l2) {
        MappedObjectUnsafe.INSTANCE.putChar(l2, c2);
    }

    public static void cput(MappedObject mappedObject, char c2, int n2) {
        MappedObjectUnsafe.INSTANCE.putChar(mappedObject.viewAddress + (long)n2, c2);
    }

    public static char cget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getChar(l2);
    }

    public static char cget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getChar(mappedObject.viewAddress + (long)n2);
    }

    public static void cvput(char c2, long l2) {
        MappedObjectUnsafe.INSTANCE.putCharVolatile(null, l2, c2);
    }

    public static void cvput(MappedObject mappedObject, char c2, int n2) {
        MappedObjectUnsafe.INSTANCE.putCharVolatile(null, mappedObject.viewAddress + (long)n2, c2);
    }

    public static char cvget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getCharVolatile(null, l2);
    }

    public static char cvget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getCharVolatile(null, mappedObject.viewAddress + (long)n2);
    }

    public static void iput(int n2, long l2) {
        MappedObjectUnsafe.INSTANCE.putInt(l2, n2);
    }

    public static void iput(MappedObject mappedObject, int n2, int n3) {
        MappedObjectUnsafe.INSTANCE.putInt(mappedObject.viewAddress + (long)n3, n2);
    }

    public static int iget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getInt(l2);
    }

    public static int iget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getInt(mappedObject.viewAddress + (long)n2);
    }

    public static void ivput(int n2, long l2) {
        MappedObjectUnsafe.INSTANCE.putIntVolatile(null, l2, n2);
    }

    public static void ivput(MappedObject mappedObject, int n2, int n3) {
        MappedObjectUnsafe.INSTANCE.putIntVolatile(null, mappedObject.viewAddress + (long)n3, n2);
    }

    public static int ivget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getIntVolatile(null, l2);
    }

    public static int ivget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getIntVolatile(null, mappedObject.viewAddress + (long)n2);
    }

    public static void fput(float f2, long l2) {
        MappedObjectUnsafe.INSTANCE.putFloat(l2, f2);
    }

    public static void fput(MappedObject mappedObject, float f2, int n2) {
        MappedObjectUnsafe.INSTANCE.putFloat(mappedObject.viewAddress + (long)n2, f2);
    }

    public static float fget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getFloat(l2);
    }

    public static float fget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getFloat(mappedObject.viewAddress + (long)n2);
    }

    public static void fvput(float f2, long l2) {
        MappedObjectUnsafe.INSTANCE.putFloatVolatile(null, l2, f2);
    }

    public static void fvput(MappedObject mappedObject, float f2, int n2) {
        MappedObjectUnsafe.INSTANCE.putFloatVolatile(null, mappedObject.viewAddress + (long)n2, f2);
    }

    public static float fvget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getFloatVolatile(null, l2);
    }

    public static float fvget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getFloatVolatile(null, mappedObject.viewAddress + (long)n2);
    }

    public static void jput(long l2, long l3) {
        MappedObjectUnsafe.INSTANCE.putLong(l3, l2);
    }

    public static void jput(MappedObject mappedObject, long l2, int n2) {
        MappedObjectUnsafe.INSTANCE.putLong(mappedObject.viewAddress + (long)n2, l2);
    }

    public static long jget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getLong(l2);
    }

    public static long jget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getLong(mappedObject.viewAddress + (long)n2);
    }

    public static void jvput(long l2, long l3) {
        MappedObjectUnsafe.INSTANCE.putLongVolatile(null, l3, l2);
    }

    public static void jvput(MappedObject mappedObject, long l2, int n2) {
        MappedObjectUnsafe.INSTANCE.putLongVolatile(null, mappedObject.viewAddress + (long)n2, l2);
    }

    public static long jvget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getLongVolatile(null, l2);
    }

    public static long jvget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getLongVolatile(null, mappedObject.viewAddress + (long)n2);
    }

    public static void aput(long l2, long l3) {
        MappedObjectUnsafe.INSTANCE.putAddress(l3, l2);
    }

    public static void aput(MappedObject mappedObject, long l2, int n2) {
        MappedObjectUnsafe.INSTANCE.putAddress(mappedObject.viewAddress + (long)n2, l2);
    }

    public static long aget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getAddress(l2);
    }

    public static long aget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getAddress(mappedObject.viewAddress + (long)n2);
    }

    public static void dput(double d2, long l2) {
        MappedObjectUnsafe.INSTANCE.putDouble(l2, d2);
    }

    public static void dput(MappedObject mappedObject, double d2, int n2) {
        MappedObjectUnsafe.INSTANCE.putDouble(mappedObject.viewAddress + (long)n2, d2);
    }

    public static double dget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getDouble(l2);
    }

    public static double dget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getDouble(mappedObject.viewAddress + (long)n2);
    }

    public static void dvput(double d2, long l2) {
        MappedObjectUnsafe.INSTANCE.putDoubleVolatile(null, l2, d2);
    }

    public static void dvput(MappedObject mappedObject, double d2, int n2) {
        MappedObjectUnsafe.INSTANCE.putDoubleVolatile(null, mappedObject.viewAddress + (long)n2, d2);
    }

    public static double dvget(long l2) {
        return MappedObjectUnsafe.INSTANCE.getDoubleVolatile(null, l2);
    }

    public static double dvget(MappedObject mappedObject, int n2) {
        return MappedObjectUnsafe.INSTANCE.getDoubleVolatile(null, mappedObject.viewAddress + (long)n2);
    }
}

