/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.mapped;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.mapped.CacheLineSize;

public final class CacheUtil {
    private static final int CACHE_LINE_SIZE;

    private CacheUtil() {
    }

    public static int getCacheLineSize() {
        return CACHE_LINE_SIZE;
    }

    public static ByteBuffer createByteBuffer(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + CACHE_LINE_SIZE);
        if (MemoryUtil.getAddress(byteBuffer) % (long)CACHE_LINE_SIZE != 0L) {
            byteBuffer.position(CACHE_LINE_SIZE - (int)(MemoryUtil.getAddress(byteBuffer) & (long)(CACHE_LINE_SIZE - 1)));
        }
        byteBuffer.limit(byteBuffer.position() + n2);
        return byteBuffer.slice().order(ByteOrder.nativeOrder());
    }

    public static ShortBuffer createShortBuffer(int n2) {
        return CacheUtil.createByteBuffer(n2 << 1).asShortBuffer();
    }

    public static CharBuffer createCharBuffer(int n2) {
        return CacheUtil.createByteBuffer(n2 << 1).asCharBuffer();
    }

    public static IntBuffer createIntBuffer(int n2) {
        return CacheUtil.createByteBuffer(n2 << 2).asIntBuffer();
    }

    public static LongBuffer createLongBuffer(int n2) {
        return CacheUtil.createByteBuffer(n2 << 3).asLongBuffer();
    }

    public static FloatBuffer createFloatBuffer(int n2) {
        return CacheUtil.createByteBuffer(n2 << 2).asFloatBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(int n2) {
        return CacheUtil.createByteBuffer(n2 << 3).asDoubleBuffer();
    }

    public static PointerBuffer createPointerBuffer(int n2) {
        return new PointerBuffer(CacheUtil.createByteBuffer(n2 * PointerBuffer.getPointerSize()));
    }

    static {
        Integer n2 = LWJGLUtil.getPrivilegedInteger("org.lwjgl.util.mapped.CacheLineSize");
        if (n2 != null) {
            if (n2 < 1) {
                throw new IllegalStateException("Invalid CacheLineSize specified: " + n2);
            }
            CACHE_LINE_SIZE = n2;
        } else if (Runtime.getRuntime().availableProcessors() == 1) {
            if (LWJGLUtil.DEBUG) {
                LWJGLUtil.log("Cannot detect cache line size on single-core CPUs, assuming 64 bytes.");
            }
            CACHE_LINE_SIZE = 64;
        } else {
            CACHE_LINE_SIZE = CacheLineSize.getCacheLineSize();
        }
    }
}

