/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.mapped;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.util.mapped.CacheUtil;
import org.lwjgl.util.mapped.MappedHelper;
import org.lwjgl.util.mapped.MappedObjectUnsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CacheLineSize {
    private CacheLineSize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getCacheLineSize() {
        int n2 = 2;
        int n3 = 200000;
        int n4 = 100000;
        int n5 = LWJGLUtil.getPrivilegedInteger("org.lwjgl.util.mapped.CacheLineMaxSize", 1024) / 4;
        double d2 = 1.0 + (double)LWJGLUtil.getPrivilegedInteger("org.lwjgl.util.mapped.CacheLineTimeThreshold", 50).intValue() / 100.0;
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<Long> executorCompletionService = new ExecutorCompletionService<Long>(executorService);
        try {
            int n6;
            IntBuffer intBuffer = CacheLineSize.getMemory(n5);
            int n7 = 10;
            for (int i2 = 0; i2 < 10; ++i2) {
                CacheLineSize.doTest(2, 100000, 0, intBuffer, executorCompletionService);
            }
            long l2 = 0L;
            int n8 = 0;
            int n9 = 64;
            boolean bl2 = false;
            for (n6 = n5; n6 >= 1; n6 >>= 1) {
                long l3;
                long l4 = CacheLineSize.doTest(2, 100000, n6, intBuffer, executorCompletionService);
                if (l2 > 0L && (double)l4 / (double)(l3 = l2 / (long)n8) > d2) {
                    n9 = (n6 << 1) * 4;
                    bl2 = true;
                    break;
                }
                l2 += l4;
                ++n8;
            }
            if (LWJGLUtil.DEBUG) {
                if (bl2) {
                    LWJGLUtil.log("Cache line size detected: " + n9 + " bytes");
                } else {
                    LWJGLUtil.log("Failed to detect cache line size, assuming " + n9 + " bytes");
                }
            }
            n6 = n9;
            return n6;
        }
        finally {
            executorService.shutdown();
        }
    }

    public static void main(String[] stringArray) {
        CacheUtil.getCacheLineSize();
    }

    static long memoryLoop(int n2, int n3, IntBuffer intBuffer, int n4) {
        long l2 = MemoryUtil.getAddress(intBuffer) + (long)(n2 * n4 * 4);
        long l3 = System.nanoTime();
        for (int i2 = 0; i2 < n3; ++i2) {
            MappedHelper.ivput(MappedHelper.ivget(l2) + 1, l2);
        }
        return System.nanoTime() - l3;
    }

    private static IntBuffer getMemory(int n2) {
        int n3 = MappedObjectUnsafe.INSTANCE.pageSize();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 * 4 + n3).order(ByteOrder.nativeOrder());
        if (MemoryUtil.getAddress(byteBuffer) % (long)n3 != 0L) {
            byteBuffer.position(n3 - (int)(MemoryUtil.getAddress(byteBuffer) & (long)(n3 - 1)));
        }
        return byteBuffer.asIntBuffer();
    }

    private static long doTest(int n2, int n3, int n4, IntBuffer intBuffer, ExecutorCompletionService<Long> executorCompletionService) {
        for (int i2 = 0; i2 < n2; ++i2) {
            CacheLineSize.submitTest(executorCompletionService, i2, n3, intBuffer, n4);
        }
        return CacheLineSize.waitForResults(n2, executorCompletionService);
    }

    private static void submitTest(ExecutorCompletionService<Long> executorCompletionService, final int n2, final int n3, final IntBuffer intBuffer, final int n4) {
        executorCompletionService.submit(new Callable<Long>(){

            @Override
            public Long call() {
                return CacheLineSize.memoryLoop(n2, n3, intBuffer, n4);
            }
        });
    }

    private static long waitForResults(int n2, ExecutorCompletionService<Long> executorCompletionService) {
        try {
            long l2 = 0L;
            for (int i2 = 0; i2 < n2; ++i2) {
                l2 += executorCompletionService.take().get().longValue();
            }
            return l2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

