/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.glu.tessellation;

import org.lwjgl.util.glu.tessellation.PriorityQ;

class PriorityQHeap
extends PriorityQ {
    PriorityQ.PQnode[] nodes = new PriorityQ.PQnode[33];
    PriorityQ.PQhandleElem[] handles;
    int size = 0;
    int max = 32;
    int freeList;
    boolean initialized;
    PriorityQ.Leq leq;

    PriorityQHeap(PriorityQ.Leq leq) {
        int n2;
        for (n2 = 0; n2 < this.nodes.length; ++n2) {
            this.nodes[n2] = new PriorityQ.PQnode();
        }
        this.handles = new PriorityQ.PQhandleElem[33];
        for (n2 = 0; n2 < this.handles.length; ++n2) {
            this.handles[n2] = new PriorityQ.PQhandleElem();
        }
        this.initialized = false;
        this.freeList = 0;
        this.leq = leq;
        this.nodes[1].handle = 1;
        this.handles[1].key = null;
    }

    void pqDeletePriorityQ() {
        this.handles = null;
        this.nodes = null;
    }

    void FloatDown(int n2) {
        PriorityQ.PQnode[] pQnodeArray = this.nodes;
        PriorityQ.PQhandleElem[] pQhandleElemArray = this.handles;
        int n3 = pQnodeArray[n2].handle;
        while (true) {
            int n4;
            if ((n4 = n2 << 1) < this.size && PriorityQHeap.LEQ(this.leq, pQhandleElemArray[pQnodeArray[n4 + 1].handle].key, pQhandleElemArray[pQnodeArray[n4].handle].key)) {
                ++n4;
            }
            assert (n4 <= this.max);
            int n5 = pQnodeArray[n4].handle;
            if (n4 > this.size || PriorityQHeap.LEQ(this.leq, pQhandleElemArray[n3].key, pQhandleElemArray[n5].key)) break;
            pQnodeArray[n2].handle = n5;
            pQhandleElemArray[n5].node = n2;
            n2 = n4;
        }
        pQnodeArray[n2].handle = n3;
        pQhandleElemArray[n3].node = n2;
    }

    void FloatUp(int n2) {
        PriorityQ.PQnode[] pQnodeArray = this.nodes;
        PriorityQ.PQhandleElem[] pQhandleElemArray = this.handles;
        int n3 = pQnodeArray[n2].handle;
        while (true) {
            int n4 = n2 >> 1;
            int n5 = pQnodeArray[n4].handle;
            if (n4 == 0 || PriorityQHeap.LEQ(this.leq, pQhandleElemArray[n5].key, pQhandleElemArray[n3].key)) break;
            pQnodeArray[n2].handle = n5;
            pQhandleElemArray[n5].node = n2;
            n2 = n4;
        }
        pQnodeArray[n2].handle = n3;
        pQhandleElemArray[n3].node = n2;
    }

    boolean pqInit() {
        for (int i2 = this.size; i2 >= 1; --i2) {
            this.FloatDown(i2);
        }
        this.initialized = true;
        return true;
    }

    int pqInsert(Object object) {
        int n2;
        int n3;
        if ((n3 = ++this.size) * 2 > this.max) {
            PriorityQ.PQnode[] pQnodeArray = this.nodes;
            PriorityQ.PQhandleElem[] pQhandleElemArray = this.handles;
            this.max <<= 1;
            PriorityQ.PQnode[] pQnodeArray2 = new PriorityQ.PQnode[this.max + 1];
            System.arraycopy(this.nodes, 0, pQnodeArray2, 0, this.nodes.length);
            for (int i2 = this.nodes.length; i2 < pQnodeArray2.length; ++i2) {
                pQnodeArray2[i2] = new PriorityQ.PQnode();
            }
            this.nodes = pQnodeArray2;
            if (this.nodes == null) {
                this.nodes = pQnodeArray;
                return Integer.MAX_VALUE;
            }
            PriorityQ.PQhandleElem[] pQhandleElemArray2 = new PriorityQ.PQhandleElem[this.max + 1];
            System.arraycopy(this.handles, 0, pQhandleElemArray2, 0, this.handles.length);
            for (int i3 = this.handles.length; i3 < pQhandleElemArray2.length; ++i3) {
                pQhandleElemArray2[i3] = new PriorityQ.PQhandleElem();
            }
            this.handles = pQhandleElemArray2;
            if (this.handles == null) {
                this.handles = pQhandleElemArray;
                return Integer.MAX_VALUE;
            }
        }
        if (this.freeList == 0) {
            n2 = n3;
        } else {
            n2 = this.freeList;
            this.freeList = this.handles[n2].node;
        }
        this.nodes[n3].handle = n2;
        this.handles[n2].node = n3;
        this.handles[n2].key = object;
        if (this.initialized) {
            this.FloatUp(n3);
        }
        assert (n2 != Integer.MAX_VALUE);
        return n2;
    }

    Object pqExtractMin() {
        PriorityQ.PQnode[] pQnodeArray = this.nodes;
        PriorityQ.PQhandleElem[] pQhandleElemArray = this.handles;
        int n2 = pQnodeArray[1].handle;
        Object object = pQhandleElemArray[n2].key;
        if (this.size > 0) {
            pQnodeArray[1].handle = pQnodeArray[this.size].handle;
            pQhandleElemArray[pQnodeArray[1].handle].node = 1;
            pQhandleElemArray[n2].key = null;
            pQhandleElemArray[n2].node = this.freeList;
            this.freeList = n2;
            if (--this.size > 0) {
                this.FloatDown(1);
            }
        }
        return object;
    }

    void pqDelete(int n2) {
        PriorityQ.PQnode[] pQnodeArray = this.nodes;
        PriorityQ.PQhandleElem[] pQhandleElemArray = this.handles;
        assert (n2 >= 1 && n2 <= this.max && pQhandleElemArray[n2].key != null);
        int n3 = pQhandleElemArray[n2].node;
        pQnodeArray[n3].handle = pQnodeArray[this.size].handle;
        pQhandleElemArray[pQnodeArray[n3].handle].node = n3;
        if (n3 <= --this.size) {
            if (n3 <= 1 || PriorityQHeap.LEQ(this.leq, pQhandleElemArray[pQnodeArray[n3 >> 1].handle].key, pQhandleElemArray[pQnodeArray[n3].handle].key)) {
                this.FloatDown(n3);
            } else {
                this.FloatUp(n3);
            }
        }
        pQhandleElemArray[n2].key = null;
        pQhandleElemArray[n2].node = this.freeList;
        this.freeList = n2;
    }

    Object pqMinimum() {
        return this.handles[this.nodes[1].handle].key;
    }

    boolean pqIsEmpty() {
        return this.size == 0;
    }
}

