/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.io.Serializable;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.WritableDimension;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public final class Rectangle
implements Serializable,
ReadableRectangle,
WritableRectangle {
    static final long serialVersionUID = 1L;
    private int x;
    private int y;
    private int width;
    private int height;

    public Rectangle() {
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public Rectangle(ReadablePoint readablePoint, ReadableDimension readableDimension) {
        this.x = readablePoint.getX();
        this.y = readablePoint.getY();
        this.width = readableDimension.getWidth();
        this.height = readableDimension.getHeight();
    }

    public Rectangle(ReadableRectangle readableRectangle) {
        this.x = readableRectangle.getX();
        this.y = readableRectangle.getY();
        this.width = readableRectangle.getWidth();
        this.height = readableRectangle.getHeight();
    }

    public void setLocation(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public void setLocation(ReadablePoint readablePoint) {
        this.x = readablePoint.getX();
        this.y = readablePoint.getY();
    }

    public void setSize(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public void setSize(ReadableDimension readableDimension) {
        this.width = readableDimension.getWidth();
        this.height = readableDimension.getHeight();
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public void setBounds(ReadablePoint readablePoint, ReadableDimension readableDimension) {
        this.x = readablePoint.getX();
        this.y = readablePoint.getY();
        this.width = readableDimension.getWidth();
        this.height = readableDimension.getHeight();
    }

    public void setBounds(ReadableRectangle readableRectangle) {
        this.x = readableRectangle.getX();
        this.y = readableRectangle.getY();
        this.width = readableRectangle.getWidth();
        this.height = readableRectangle.getHeight();
    }

    public void getBounds(WritableRectangle writableRectangle) {
        writableRectangle.setBounds(this.x, this.y, this.width, this.height);
    }

    public void getLocation(WritablePoint writablePoint) {
        writablePoint.setLocation(this.x, this.y);
    }

    public void getSize(WritableDimension writableDimension) {
        writableDimension.setSize(this.width, this.height);
    }

    public void translate(int n2, int n3) {
        this.x += n2;
        this.y += n3;
    }

    public void translate(ReadablePoint readablePoint) {
        this.x += readablePoint.getX();
        this.y += readablePoint.getY();
    }

    public void untranslate(ReadablePoint readablePoint) {
        this.x -= readablePoint.getX();
        this.y -= readablePoint.getY();
    }

    public boolean contains(ReadablePoint readablePoint) {
        return this.contains(readablePoint.getX(), readablePoint.getY());
    }

    public boolean contains(int n2, int n3) {
        int n4 = this.width;
        int n5 = this.height;
        if ((n4 | n5) < 0) {
            return false;
        }
        int n6 = this.x;
        int n7 = this.y;
        if (n2 < n6 || n3 < n7) {
            return false;
        }
        n5 += n7;
        return !((n4 += n6) >= n6 && n4 <= n2 || n5 >= n7 && n5 <= n3);
    }

    public boolean contains(ReadableRectangle readableRectangle) {
        return this.contains(readableRectangle.getX(), readableRectangle.getY(), readableRectangle.getWidth(), readableRectangle.getHeight());
    }

    public boolean contains(int n2, int n3, int n4, int n5) {
        int n6 = this.width;
        int n7 = this.height;
        if ((n6 | n7 | n4 | n5) < 0) {
            return false;
        }
        int n8 = this.x;
        int n9 = this.y;
        if (n2 < n8 || n3 < n9) {
            return false;
        }
        n6 += n8;
        if ((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6) {
            return false;
        }
        n7 += n9;
        return !((n5 += n3) <= n3 ? n7 >= n9 || n5 > n7 : n7 >= n9 && n5 > n7);
    }

    public boolean intersects(ReadableRectangle readableRectangle) {
        int n2 = this.width;
        int n3 = this.height;
        int n4 = readableRectangle.getWidth();
        int n5 = readableRectangle.getHeight();
        if (n4 <= 0 || n5 <= 0 || n2 <= 0 || n3 <= 0) {
            return false;
        }
        int n6 = this.x;
        int n7 = this.y;
        int n8 = readableRectangle.getX();
        int n9 = readableRectangle.getY();
        n5 += n9;
        n2 += n6;
        n3 += n7;
        return !((n4 += n8) >= n8 && n4 <= n6 || n5 >= n9 && n5 <= n7 || n2 >= n6 && n2 <= n8 || n3 >= n7 && n3 <= n9);
    }

    public Rectangle intersection(ReadableRectangle readableRectangle, Rectangle rectangle) {
        int n2 = this.x;
        int n3 = this.y;
        int n4 = readableRectangle.getX();
        int n5 = readableRectangle.getY();
        long l2 = n2;
        l2 += (long)this.width;
        long l3 = n3;
        l3 += (long)this.height;
        long l4 = n4;
        l4 += (long)readableRectangle.getWidth();
        long l5 = n5;
        l5 += (long)readableRectangle.getHeight();
        if (n2 < n4) {
            n2 = n4;
        }
        if (n3 < n5) {
            n3 = n5;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        if (l3 > l5) {
            l3 = l5;
        }
        l3 -= (long)n3;
        if ((l2 -= (long)n2) < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        if (l3 < Integer.MIN_VALUE) {
            l3 = Integer.MIN_VALUE;
        }
        if (rectangle == null) {
            rectangle = new Rectangle(n2, n3, (int)l2, (int)l3);
        } else {
            rectangle.setBounds(n2, n3, (int)l2, (int)l3);
        }
        return rectangle;
    }

    public WritableRectangle union(ReadableRectangle readableRectangle, WritableRectangle writableRectangle) {
        int n2 = Math.min(this.x, readableRectangle.getX());
        int n3 = Math.max(this.x + this.width, readableRectangle.getX() + readableRectangle.getWidth());
        int n4 = Math.min(this.y, readableRectangle.getY());
        int n5 = Math.max(this.y + this.height, readableRectangle.getY() + readableRectangle.getHeight());
        writableRectangle.setBounds(n2, n4, n3 - n2, n5 - n4);
        return writableRectangle;
    }

    public void add(int n2, int n3) {
        int n4 = Math.min(this.x, n2);
        int n5 = Math.max(this.x + this.width, n2);
        int n6 = Math.min(this.y, n3);
        int n7 = Math.max(this.y + this.height, n3);
        this.x = n4;
        this.y = n6;
        this.width = n5 - n4;
        this.height = n7 - n6;
    }

    public void add(ReadablePoint readablePoint) {
        this.add(readablePoint.getX(), readablePoint.getY());
    }

    public void add(ReadableRectangle readableRectangle) {
        int n2 = Math.min(this.x, readableRectangle.getX());
        int n3 = Math.max(this.x + this.width, readableRectangle.getX() + readableRectangle.getWidth());
        int n4 = Math.min(this.y, readableRectangle.getY());
        int n5 = Math.max(this.y + this.height, readableRectangle.getY() + readableRectangle.getHeight());
        this.x = n2;
        this.y = n4;
        this.width = n3 - n2;
        this.height = n5 - n4;
    }

    public void grow(int n2, int n3) {
        this.x -= n2;
        this.y -= n3;
        this.width += n2 * 2;
        this.height += n3 * 2;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return super.equals(object);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n2) {
        this.x = n2;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n2) {
        this.y = n2;
    }
}

