/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.io.Serializable;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.WritablePoint;

public final class Point
implements Serializable,
ReadablePoint,
WritablePoint {
    static final long serialVersionUID = 1L;
    private int x;
    private int y;

    public Point() {
    }

    public Point(int n2, int n3) {
        this.setLocation(n2, n3);
    }

    public Point(ReadablePoint readablePoint) {
        this.setLocation(readablePoint);
    }

    public void setLocation(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public void setLocation(ReadablePoint readablePoint) {
        this.x = readablePoint.getX();
        this.y = readablePoint.getY();
    }

    public void setX(int n2) {
        this.x = n2;
    }

    public void setY(int n2) {
        this.y = n2;
    }

    public void translate(int n2, int n3) {
        this.x += n2;
        this.y += n3;
    }

    public void translate(ReadablePoint readablePoint) {
        this.x += readablePoint.getX();
        this.y += readablePoint.getY();
    }

    public void untranslate(ReadablePoint readablePoint) {
        this.x -= readablePoint.getX();
        this.y -= readablePoint.getY();
    }

    public boolean equals(Object object) {
        if (object instanceof Point) {
            Point point = (Point)object;
            return this.x == point.x && this.y == point.y;
        }
        return super.equals(object);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + "]";
    }

    public int hashCode() {
        int n2 = this.x + this.y;
        return n2 * (n2 + 1) / 2 + this.x;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void getLocation(WritablePoint writablePoint) {
        writablePoint.setLocation(this.x, this.y);
    }
}

