/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.DisplayMode;

public final class Display {
    private static final boolean DEBUG = false;

    public static DisplayMode[] getAvailableDisplayModes(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        DisplayMode[] displayModeArray = org.lwjgl.opengl.Display.getAvailableDisplayModes();
        if (LWJGLUtil.DEBUG) {
            System.out.println("Available screen modes:");
            for (DisplayMode displayMode : displayModeArray) {
                System.out.println(displayMode);
            }
        }
        ArrayList arrayList = new ArrayList(displayModeArray.length);
        for (int i2 = 0; i2 < displayModeArray.length; ++i2) {
            assert (displayModeArray[i2] != null) : "" + i2 + " " + displayModeArray.length;
            if (n2 != -1 && displayModeArray[i2].getWidth() < n2 || n4 != -1 && displayModeArray[i2].getWidth() > n4 || n3 != -1 && displayModeArray[i2].getHeight() < n3 || n5 != -1 && displayModeArray[i2].getHeight() > n5 || n6 != -1 && displayModeArray[i2].getBitsPerPixel() < n6 || n7 != -1 && displayModeArray[i2].getBitsPerPixel() > n7 || displayModeArray[i2].getFrequency() != 0 && (n8 != -1 && displayModeArray[i2].getFrequency() < n8 || n9 != -1 && displayModeArray[i2].getFrequency() > n9)) continue;
            arrayList.add(displayModeArray[i2]);
        }
        DisplayMode[] displayModeArray2 = new DisplayMode[arrayList.size()];
        arrayList.toArray(displayModeArray2);
        if (LWJGLUtil.DEBUG) {
            // empty if block
        }
        return displayModeArray2;
    }

    public static DisplayMode setDisplayMode(DisplayMode[] displayModeArray, String[] stringArray) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Sorter
        implements Comparator<DisplayMode> {
            final 1FieldAccessor[] accessors;
            final /* synthetic */ String[] val$param;

            Sorter(String[] stringArray) {
                this.val$param = stringArray;
                class FieldAccessor {
                    final String fieldName;
                    final int order;
                    final int preferred;
                    final boolean usePreferred;

                    FieldAccessor(String string, int n2, int n3, boolean bl2) {
                        this.fieldName = string;
                        this.order = n2;
                        this.preferred = n3;
                        this.usePreferred = bl2;
                    }

                    int getInt(DisplayMode displayMode) {
                        if ("width".equals(this.fieldName)) {
                            return displayMode.getWidth();
                        }
                        if ("height".equals(this.fieldName)) {
                            return displayMode.getHeight();
                        }
                        if ("freq".equals(this.fieldName)) {
                            return displayMode.getFrequency();
                        }
                        if ("bpp".equals(this.fieldName)) {
                            return displayMode.getBitsPerPixel();
                        }
                        throw new IllegalArgumentException("Unknown field " + this.fieldName);
                    }
                }
                this.accessors = new FieldAccessor[this.val$param.length];
                for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                    int n2 = this.val$param[i2].indexOf(61);
                    this.accessors[i2] = n2 > 0 ? new FieldAccessor(this.val$param[i2].substring(0, n2), 0, Integer.parseInt(this.val$param[i2].substring(n2 + 1, this.val$param[i2].length())), true) : (this.val$param[i2].charAt(0) == '-' ? new FieldAccessor(this.val$param[i2].substring(1), -1, 0, false) : new FieldAccessor(this.val$param[i2], 1, 0, false));
                }
            }

            @Override
            public int compare(DisplayMode displayMode, DisplayMode displayMode2) {
                for (FieldAccessor fieldAccessor : this.accessors) {
                    int n2 = fieldAccessor.getInt(displayMode);
                    int n3 = fieldAccessor.getInt(displayMode2);
                    if (fieldAccessor.usePreferred && n2 != n3) {
                        int n4;
                        if (n2 == fieldAccessor.preferred) {
                            return -1;
                        }
                        if (n3 == fieldAccessor.preferred) {
                            return 1;
                        }
                        int n5 = Math.abs(n2 - fieldAccessor.preferred);
                        if (n5 < (n4 = Math.abs(n3 - fieldAccessor.preferred))) {
                            return -1;
                        }
                        if (n5 <= n4) continue;
                        return 1;
                    }
                    if (n2 < n3) {
                        return fieldAccessor.order;
                    }
                    if (n2 == n3) continue;
                    return -fieldAccessor.order;
                }
                return 0;
            }
        }
        Arrays.sort(displayModeArray, new Sorter(stringArray));
        if (LWJGLUtil.DEBUG) {
            System.out.println("Sorted display modes:");
            for (DisplayMode displayMode : displayModeArray) {
                System.out.println(displayMode);
            }
        }
        for (DisplayMode displayMode : displayModeArray) {
            try {
                if (LWJGLUtil.DEBUG) {
                    System.out.println("Attempting to set displaymode: " + displayMode);
                }
                org.lwjgl.opengl.Display.setDisplayMode(displayMode);
                return displayMode;
            }
            catch (Exception exception) {
                if (!LWJGLUtil.DEBUG) continue;
                System.out.println("Failed to set display mode to " + displayMode);
                exception.printStackTrace();
            }
        }
        throw new Exception("Failed to set display mode.");
    }
}

