/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public final class Color
implements Serializable,
ReadableColor,
WritableColor {
    static final long serialVersionUID = 1L;
    private byte red;
    private byte green;
    private byte blue;
    private byte alpha;

    public Color() {
        this(0, 0, 0, 255);
    }

    public Color(int n2, int n3, int n4) {
        this(n2, n3, n4, 255);
    }

    public Color(byte by2, byte by3, byte by4) {
        this(by2, by3, by4, -1);
    }

    public Color(int n2, int n3, int n4, int n5) {
        this.set(n2, n3, n4, n5);
    }

    public Color(byte by2, byte by3, byte by4, byte by5) {
        this.set(by2, by3, by4, by5);
    }

    public Color(ReadableColor readableColor) {
        this.setColor(readableColor);
    }

    public void set(int n2, int n3, int n4, int n5) {
        this.red = (byte)n2;
        this.green = (byte)n3;
        this.blue = (byte)n4;
        this.alpha = (byte)n5;
    }

    public void set(byte by2, byte by3, byte by4, byte by5) {
        this.red = by2;
        this.green = by3;
        this.blue = by4;
        this.alpha = by5;
    }

    public void set(int n2, int n3, int n4) {
        this.set(n2, n3, n4, 255);
    }

    public void set(byte by2, byte by3, byte by4) {
        this.set(by2, by3, by4, (byte)-1);
    }

    public int getRed() {
        return this.red & 0xFF;
    }

    public int getGreen() {
        return this.green & 0xFF;
    }

    public int getBlue() {
        return this.blue & 0xFF;
    }

    public int getAlpha() {
        return this.alpha & 0xFF;
    }

    public void setRed(int n2) {
        this.red = (byte)n2;
    }

    public void setGreen(int n2) {
        this.green = (byte)n2;
    }

    public void setBlue(int n2) {
        this.blue = (byte)n2;
    }

    public void setAlpha(int n2) {
        this.alpha = (byte)n2;
    }

    public void setRed(byte by2) {
        this.red = by2;
    }

    public void setGreen(byte by2) {
        this.green = by2;
    }

    public void setBlue(byte by2) {
        this.blue = by2;
    }

    public void setAlpha(byte by2) {
        this.alpha = by2;
    }

    public String toString() {
        return "Color [" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "]";
    }

    public boolean equals(Object object) {
        return object != null && object instanceof ReadableColor && ((ReadableColor)object).getRed() == this.getRed() && ((ReadableColor)object).getGreen() == this.getGreen() && ((ReadableColor)object).getBlue() == this.getBlue() && ((ReadableColor)object).getAlpha() == this.getAlpha();
    }

    public int hashCode() {
        return this.red << 24 | this.green << 16 | this.blue << 8 | this.alpha;
    }

    public byte getAlphaByte() {
        return this.alpha;
    }

    public byte getBlueByte() {
        return this.blue;
    }

    public byte getGreenByte() {
        return this.green;
    }

    public byte getRedByte() {
        return this.red;
    }

    public void writeRGBA(ByteBuffer byteBuffer) {
        byteBuffer.put(this.red);
        byteBuffer.put(this.green);
        byteBuffer.put(this.blue);
        byteBuffer.put(this.alpha);
    }

    public void writeRGB(ByteBuffer byteBuffer) {
        byteBuffer.put(this.red);
        byteBuffer.put(this.green);
        byteBuffer.put(this.blue);
    }

    public void writeABGR(ByteBuffer byteBuffer) {
        byteBuffer.put(this.alpha);
        byteBuffer.put(this.blue);
        byteBuffer.put(this.green);
        byteBuffer.put(this.red);
    }

    public void writeARGB(ByteBuffer byteBuffer) {
        byteBuffer.put(this.alpha);
        byteBuffer.put(this.red);
        byteBuffer.put(this.green);
        byteBuffer.put(this.blue);
    }

    public void writeBGR(ByteBuffer byteBuffer) {
        byteBuffer.put(this.blue);
        byteBuffer.put(this.green);
        byteBuffer.put(this.red);
    }

    public void writeBGRA(ByteBuffer byteBuffer) {
        byteBuffer.put(this.blue);
        byteBuffer.put(this.green);
        byteBuffer.put(this.red);
        byteBuffer.put(this.alpha);
    }

    public void readRGBA(ByteBuffer byteBuffer) {
        this.red = byteBuffer.get();
        this.green = byteBuffer.get();
        this.blue = byteBuffer.get();
        this.alpha = byteBuffer.get();
    }

    public void readRGB(ByteBuffer byteBuffer) {
        this.red = byteBuffer.get();
        this.green = byteBuffer.get();
        this.blue = byteBuffer.get();
    }

    public void readARGB(ByteBuffer byteBuffer) {
        this.alpha = byteBuffer.get();
        this.red = byteBuffer.get();
        this.green = byteBuffer.get();
        this.blue = byteBuffer.get();
    }

    public void readBGRA(ByteBuffer byteBuffer) {
        this.blue = byteBuffer.get();
        this.green = byteBuffer.get();
        this.red = byteBuffer.get();
        this.alpha = byteBuffer.get();
    }

    public void readBGR(ByteBuffer byteBuffer) {
        this.blue = byteBuffer.get();
        this.green = byteBuffer.get();
        this.red = byteBuffer.get();
    }

    public void readABGR(ByteBuffer byteBuffer) {
        this.alpha = byteBuffer.get();
        this.blue = byteBuffer.get();
        this.green = byteBuffer.get();
        this.red = byteBuffer.get();
    }

    public void setColor(ReadableColor readableColor) {
        this.red = readableColor.getRedByte();
        this.green = readableColor.getGreenByte();
        this.blue = readableColor.getBlueByte();
        this.alpha = readableColor.getAlphaByte();
    }

    public void fromHSB(float f2, float f3, float f4) {
        if (f3 == 0.0f) {
            this.green = this.blue = (byte)(f4 * 255.0f + 0.5f);
            this.red = this.blue;
        } else {
            float f5 = (f2 - (float)Math.floor(f2)) * 6.0f;
            float f6 = f5 - (float)Math.floor(f5);
            float f7 = f4 * (1.0f - f3);
            float f8 = f4 * (1.0f - f3 * f6);
            float f9 = f4 * (1.0f - f3 * (1.0f - f6));
            switch ((int)f5) {
                case 0: {
                    this.red = (byte)(f4 * 255.0f + 0.5f);
                    this.green = (byte)(f9 * 255.0f + 0.5f);
                    this.blue = (byte)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    this.red = (byte)(f8 * 255.0f + 0.5f);
                    this.green = (byte)(f4 * 255.0f + 0.5f);
                    this.blue = (byte)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    this.red = (byte)(f7 * 255.0f + 0.5f);
                    this.green = (byte)(f4 * 255.0f + 0.5f);
                    this.blue = (byte)(f9 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    this.red = (byte)(f7 * 255.0f + 0.5f);
                    this.green = (byte)(f8 * 255.0f + 0.5f);
                    this.blue = (byte)(f4 * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    this.red = (byte)(f9 * 255.0f + 0.5f);
                    this.green = (byte)(f7 * 255.0f + 0.5f);
                    this.blue = (byte)(f4 * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    this.red = (byte)(f4 * 255.0f + 0.5f);
                    this.green = (byte)(f7 * 255.0f + 0.5f);
                    this.blue = (byte)(f8 * 255.0f + 0.5f);
                }
            }
        }
    }

    public float[] toHSB(float[] fArray) {
        float f2;
        int n2;
        int n3;
        int n4 = this.getRed();
        int n5 = this.getGreen();
        int n6 = this.getBlue();
        if (fArray == null) {
            fArray = new float[3];
        }
        int n7 = n3 = n4 <= n5 ? n5 : n4;
        if (n6 > n3) {
            n3 = n6;
        }
        int n8 = n2 = n4 >= n5 ? n5 : n4;
        if (n6 < n2) {
            n2 = n6;
        }
        float f3 = (float)n3 / 255.0f;
        float f4 = n3 != 0 ? (float)(n3 - n2) / (float)n3 : 0.0f;
        if (f4 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f5 = (float)(n3 - n4) / (float)(n3 - n2);
            float f6 = (float)(n3 - n5) / (float)(n3 - n2);
            float f7 = (float)(n3 - n6) / (float)(n3 - n2);
            f2 = n4 == n3 ? f7 - f6 : (n5 == n3 ? 2.0f + f5 - f7 : 4.0f + f6 - f5);
            if ((f2 /= 6.0f) < 0.0f) {
                f2 += 1.0f;
            }
        }
        fArray[0] = f2;
        fArray[1] = f4;
        fArray[2] = f3;
        return fArray;
    }
}

