/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;

public final class ContextAttribs {
    private int version;

    public ContextAttribs() {
        this(2);
    }

    public ContextAttribs(int n2) {
        if (3 < n2) {
            throw new IllegalArgumentException("Invalid OpenGL ES version specified: " + n2);
        }
        this.version = n2;
    }

    private ContextAttribs(ContextAttribs contextAttribs) {
        this.version = contextAttribs.version;
    }

    public int getVersion() {
        return this.version;
    }

    public IntBuffer getAttribList() {
        int n2 = 1;
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n2 * 2 + 1);
        intBuffer.put(12440).put(this.version);
        intBuffer.put(12344);
        intBuffer.rewind();
        return intBuffer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("ContextAttribs:");
        stringBuilder.append(" Version=").append(this.version);
        return stringBuilder.toString();
    }
}

