/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.DisplayMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRandR {
    private static Screen[] current;
    private static String primaryScreenIdentifier;
    private static Screen[] savedConfiguration;
    private static Map<String, Screen[]> screens;
    private static final Pattern WHITESPACE_PATTERN;
    private static final Pattern SCREEN_HEADER_PATTERN;
    private static final Pattern SCREEN_MODELINE_PATTERN;
    private static final Pattern FREQ_PATTERN;

    private static void populate() {
        if (screens != null) {
            return;
        }
        screens = new HashMap<String, Screen[]>();
        try {
            String string;
            Process process = Runtime.getRuntime().exec(new String[]{"xrandr", "-q"});
            ArrayList<Screen> arrayList = new ArrayList<Screen>();
            ArrayList<Screen> arrayList2 = new ArrayList<Screen>();
            String string2 = null;
            int[] nArray = new int[2];
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = WHITESPACE_PATTERN.split(string = string.trim());
                if ("connected".equals(stringArray[1])) {
                    if (string2 != null) {
                        screens.put(string2, arrayList2.toArray(new Screen[arrayList2.size()]));
                        arrayList2.clear();
                    }
                    string2 = stringArray[0];
                    if ("primary".equals(stringArray[2])) {
                        XRandR.parseScreenHeader(nArray, stringArray[3]);
                        primaryScreenIdentifier = string2;
                        continue;
                    }
                    XRandR.parseScreenHeader(nArray, stringArray[2]);
                    continue;
                }
                Matcher matcher = SCREEN_MODELINE_PATTERN.matcher(stringArray[0]);
                if (!matcher.matches()) continue;
                XRandR.parseScreenModeline(arrayList2, arrayList, string2, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), stringArray, nArray);
            }
            screens.put(string2, arrayList2.toArray(new Screen[arrayList2.size()]));
            current = arrayList.toArray(new Screen[arrayList.size()]);
            if (primaryScreenIdentifier == null) {
                long l2 = Long.MIN_VALUE;
                for (Screen screen : current) {
                    if (1L * (long)screen.width * (long)screen.height <= l2) continue;
                    primaryScreenIdentifier = screen.name;
                    l2 = 1L * (long)screen.width * (long)screen.height;
                }
            }
        }
        catch (Throwable throwable) {
            LWJGLUtil.log("Exception in XRandR.populate(): " + throwable.getMessage());
            screens.clear();
            current = new Screen[0];
        }
    }

    public static Screen[] getConfiguration() {
        XRandR.populate();
        for (Screen screen : current) {
            if (!screen.name.equals(primaryScreenIdentifier)) continue;
            return new Screen[]{screen};
        }
        return (Screen[])current.clone();
    }

    public static void setConfiguration(boolean bl2, Screen ... screenArray) {
        if (screenArray.length == 0) {
            throw new IllegalArgumentException("Must specify at least one screen");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("xrandr");
        if (bl2) {
            for (Screen screen : current) {
                boolean bl3 = true;
                for (Screen screen2 : screenArray) {
                    if (!screen2.name.equals(screen.name)) continue;
                    bl3 = false;
                    break;
                }
                if (!bl3) continue;
                arrayList.add("--output");
                arrayList.add(screen.name);
                arrayList.add("--off");
            }
        }
        for (Screen screen : screenArray) {
            screen.getArgs(arrayList);
        }
        try {
            String string;
            Process process = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                LWJGLUtil.log("Unexpected output from xrandr process: " + string);
            }
            current = screenArray;
        }
        catch (IOException iOException) {
            LWJGLUtil.log("XRandR exception in setConfiguration(): " + iOException.getMessage());
        }
    }

    public static void saveConfiguration() {
        XRandR.populate();
        savedConfiguration = (Screen[])current.clone();
    }

    public static void restoreConfiguration() {
        if (savedConfiguration != null) {
            XRandR.setConfiguration(true, savedConfiguration);
        }
    }

    public static String[] getScreenNames() {
        XRandR.populate();
        return screens.keySet().toArray(new String[screens.size()]);
    }

    public static Screen[] getResolutions(String string) {
        XRandR.populate();
        return (Screen[])screens.get(string).clone();
    }

    private static void parseScreenModeline(List<Screen> list, List<Screen> list2, String string, int n2, int n3, String[] stringArray, int[] nArray) {
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if ("+".equals(string2)) continue;
            Matcher matcher = FREQ_PATTERN.matcher(string2);
            if (!matcher.matches()) {
                LWJGLUtil.log("Frequency match failed: " + Arrays.toString(stringArray));
                return;
            }
            int n4 = Integer.parseInt(matcher.group(1));
            Screen screen = new Screen(string, n2, n3, n4, 0, 0);
            if (string2.contains("*")) {
                list2.add(new Screen(string, n2, n3, n4, nArray[0], nArray[1]));
                list.add(0, screen);
                continue;
            }
            list.add(screen);
        }
    }

    private static void parseScreenHeader(int[] nArray, String string) {
        Matcher matcher = SCREEN_HEADER_PATTERN.matcher(string);
        if (!matcher.matches()) {
            nArray[0] = 0;
            nArray[1] = 0;
            return;
        }
        nArray[0] = Integer.parseInt(matcher.group(3));
        nArray[1] = Integer.parseInt(matcher.group(4));
    }

    static Screen DisplayModetoScreen(DisplayMode displayMode) {
        XRandR.populate();
        Screen screen = XRandR.findPrimary(current);
        return new Screen(screen.name, displayMode.getWidth(), displayMode.getHeight(), displayMode.getFrequency(), screen.xPos, screen.yPos);
    }

    static DisplayMode ScreentoDisplayMode(Screen ... screenArray) {
        XRandR.populate();
        Screen screen = XRandR.findPrimary(screenArray);
        return new DisplayMode(screen.width, screen.height, 24, screen.freq);
    }

    private static Screen findPrimary(Screen ... screenArray) {
        for (Screen screen : screenArray) {
            if (!screen.name.equals(primaryScreenIdentifier)) continue;
            return screen;
        }
        return screenArray[0];
    }

    static {
        WHITESPACE_PATTERN = Pattern.compile("\\s+");
        SCREEN_HEADER_PATTERN = Pattern.compile("^(\\d+)x(\\d+)[+](\\d+)[+](\\d+)$");
        SCREEN_MODELINE_PATTERN = Pattern.compile("^(\\d+)x(\\d+)$");
        FREQ_PATTERN = Pattern.compile("^(\\d+)[.](\\d+)(?:\\s*[*])?(?:\\s*[+])?$");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Screen
    implements Cloneable {
        public final String name;
        public final int width;
        public final int height;
        public final int freq;
        public int xPos;
        public int yPos;

        Screen(String string, int n2, int n3, int n4, int n5, int n6) {
            this.name = string;
            this.width = n2;
            this.height = n3;
            this.freq = n4;
            this.xPos = n5;
            this.yPos = n6;
        }

        private void getArgs(List<String> list) {
            list.add("--output");
            list.add(this.name);
            list.add("--mode");
            list.add(this.width + "x" + this.height);
            list.add("--rate");
            list.add(Integer.toString(this.freq));
            list.add("--pos");
            list.add(this.xPos + "x" + this.yPos);
        }

        public String toString() {
            return this.name + " " + this.width + "x" + this.height + " @ " + this.xPos + "x" + this.yPos + " with " + this.freq + "Hz";
        }
    }
}

