/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.EventQueue;
import org.lwjgl.opengl.WindowsDisplay;

final class WindowsMouse {
    private final long hwnd;
    private final int mouse_button_count;
    private final boolean has_wheel;
    private final EventQueue event_queue = new EventQueue(22);
    private final ByteBuffer mouse_event = ByteBuffer.allocate(22);
    private final Object blank_cursor;
    private boolean mouse_grabbed;
    private byte[] button_states;
    private int accum_dx;
    private int accum_dy;
    private int accum_dwheel;
    private int last_x;
    private int last_y;

    WindowsMouse(long l2) {
        this.hwnd = l2;
        this.mouse_button_count = Math.min(5, WindowsDisplay.getSystemMetrics(43));
        this.has_wheel = WindowsDisplay.getSystemMetrics(75) != 0;
        this.blank_cursor = this.createBlankCursor();
        this.button_states = new byte[this.mouse_button_count];
    }

    private Object createBlankCursor() {
        int n2 = WindowsDisplay.getSystemMetrics(13);
        int n3 = WindowsDisplay.getSystemMetrics(14);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n2 * n3);
        return WindowsDisplay.doCreateCursor(n2, n3, 0, 0, 1, intBuffer, null);
    }

    public boolean isGrabbed() {
        return this.mouse_grabbed;
    }

    public boolean hasWheel() {
        return this.has_wheel;
    }

    public int getButtonCount() {
        return this.mouse_button_count;
    }

    public void poll(IntBuffer intBuffer, ByteBuffer byteBuffer, WindowsDisplay windowsDisplay) {
        int n2;
        for (n2 = 0; n2 < intBuffer.remaining(); ++n2) {
            intBuffer.put(intBuffer.position() + n2, 0);
        }
        n2 = this.mouse_button_count;
        intBuffer.put(intBuffer.position() + 2, this.accum_dwheel);
        if (n2 > this.button_states.length) {
            n2 = this.button_states.length;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            byteBuffer.put(byteBuffer.position() + i2, this.button_states[i2]);
        }
        if (this.isGrabbed()) {
            intBuffer.put(intBuffer.position() + 0, this.accum_dx);
            intBuffer.put(intBuffer.position() + 1, this.accum_dy);
            if (windowsDisplay.isActive() && windowsDisplay.isVisible() && (this.accum_dx != 0 || this.accum_dy != 0)) {
                this.centerCursor();
            }
        } else {
            intBuffer.put(intBuffer.position() + 0, this.last_x);
            intBuffer.put(intBuffer.position() + 1, this.last_y);
        }
        this.accum_dwheel = 0;
        this.accum_dy = 0;
        this.accum_dx = 0;
    }

    private void putMouseEventWithCoords(byte by2, byte by3, int n2, int n3, int n4, long l2) {
        this.mouse_event.clear();
        this.mouse_event.put(by2).put(by3).putInt(n2).putInt(n3).putInt(n4).putLong(l2);
        this.mouse_event.flip();
        this.event_queue.putEvent(this.mouse_event);
    }

    private void putMouseEvent(byte by2, byte by3, int n2, long l2) {
        if (this.mouse_grabbed) {
            this.putMouseEventWithCoords(by2, by3, 0, 0, n2, l2);
        } else {
            this.putMouseEventWithCoords(by2, by3, this.last_x, this.last_y, n2, l2);
        }
    }

    public void read(ByteBuffer byteBuffer) {
        this.event_queue.copyEvents(byteBuffer);
    }

    public Object getBlankCursor() {
        return this.blank_cursor;
    }

    public void grab(boolean bl2, boolean bl3) {
        if (bl2) {
            if (!this.mouse_grabbed) {
                this.mouse_grabbed = true;
                if (bl3) {
                    try {
                        WindowsDisplay.setupCursorClipping(this.hwnd);
                    }
                    catch (LWJGLException lWJGLException) {
                        LWJGLUtil.log("Failed to setup cursor clipping: " + lWJGLException);
                    }
                    this.centerCursor();
                }
            }
        } else if (this.mouse_grabbed) {
            this.mouse_grabbed = false;
            WindowsDisplay.resetCursorClipping();
        }
        this.event_queue.clearEvents();
    }

    public void handleMouseScrolled(int n2, long l2) {
        this.accum_dwheel += n2;
        this.putMouseEvent((byte)-1, (byte)0, n2, l2 * 1000000L);
    }

    private void centerCursor() {
        WindowsDisplay.centerCursor(this.hwnd);
    }

    public void setPosition(int n2, int n3) {
        this.last_x = n2;
        this.last_y = n3;
    }

    public void destroy() {
        WindowsDisplay.doDestroyCursor(this.blank_cursor);
    }

    public void handleMouseMoved(int n2, int n3, long l2) {
        int n4 = n2 - this.last_x;
        int n5 = n3 - this.last_y;
        if (n4 != 0 || n5 != 0) {
            this.accum_dx += n4;
            this.accum_dy += n5;
            this.last_x = n2;
            this.last_y = n3;
            long l3 = l2 * 1000000L;
            if (this.mouse_grabbed) {
                this.putMouseEventWithCoords((byte)-1, (byte)0, n4, n5, 0, l3);
            } else {
                this.putMouseEventWithCoords((byte)-1, (byte)0, n2, n3, 0, l3);
            }
        }
    }

    public void handleMouseButton(byte by2, byte by3, long l2) {
        this.putMouseEvent(by2, by3, 0, l2 * 1000000L);
        if (by2 < this.button_states.length) {
            this.button_states[by2] = by3 != 0 ? (byte)1 : 0;
        }
    }
}

