/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.lwjgl.opengl.EventQueue;
import org.lwjgl.opengl.WindowsKeycodes;

final class WindowsKeyboard {
    private final byte[] key_down_buffer = new byte[256];
    private final byte[] virt_key_down_buffer = new byte[256];
    private final EventQueue event_queue = new EventQueue(18);
    private final ByteBuffer tmp_event = ByteBuffer.allocate(18);
    private boolean has_retained_event;
    private int retained_key_code;
    private byte retained_state;
    private int retained_char;
    private long retained_millis;
    private boolean retained_repeat;

    WindowsKeyboard() {
    }

    private static native boolean isWindowsNT();

    boolean isKeyDown(int n2) {
        return this.key_down_buffer[n2] == 1;
    }

    void poll(ByteBuffer byteBuffer) {
        if (this.isKeyDown(42) && !WindowsKeyboard.isKeyPressedAsync(160)) {
            this.handleKey(16, 42, false, (byte)0, 0L, false);
        }
        if (this.isKeyDown(54) && !WindowsKeyboard.isKeyPressedAsync(161)) {
            this.handleKey(16, 54, false, (byte)0, 0L, false);
        }
        int n2 = byteBuffer.position();
        byteBuffer.put(this.key_down_buffer);
        byteBuffer.position(n2);
    }

    private static native int MapVirtualKey(int var0, int var1);

    private static native int ToUnicode(int var0, int var1, ByteBuffer var2, CharBuffer var3, int var4, int var5);

    private static native int ToAscii(int var0, int var1, ByteBuffer var2, ByteBuffer var3, int var4);

    private static native int GetKeyboardState(ByteBuffer var0);

    private static native short GetKeyState(int var0);

    private static native short GetAsyncKeyState(int var0);

    private void putEvent(int n2, byte by2, int n3, long l2, boolean bl2) {
        this.tmp_event.clear();
        this.tmp_event.putInt(n2).put(by2).putInt(n3).putLong(l2 * 1000000L).put(bl2 ? (byte)1 : 0);
        this.tmp_event.flip();
        this.event_queue.putEvent(this.tmp_event);
    }

    private static int translateExtended(int n2, int n3, boolean bl2) {
        switch (n2) {
            case 16: {
                return n3 == 54 ? 161 : 160;
            }
            case 17: {
                return bl2 ? 163 : 162;
            }
            case 18: {
                return bl2 ? 165 : 164;
            }
        }
        return n2;
    }

    private void flushRetained() {
        if (this.has_retained_event) {
            this.has_retained_event = false;
            this.putEvent(this.retained_key_code, this.retained_state, this.retained_char, this.retained_millis, this.retained_repeat);
        }
    }

    private static boolean isKeyPressed(int n2) {
        return (n2 & 1) == 1;
    }

    private static boolean isKeyPressedAsync(int n2) {
        return (WindowsKeyboard.GetAsyncKeyState(n2) & 0x8000) != 0;
    }

    void releaseAll(long l2) {
        for (int i2 = 0; i2 < this.virt_key_down_buffer.length; ++i2) {
            if (!WindowsKeyboard.isKeyPressed(this.virt_key_down_buffer[i2])) continue;
            this.handleKey(i2, 0, false, (byte)0, l2, false);
        }
    }

    void handleKey(int n2, int n3, boolean bl2, byte by2, long l2, boolean bl3) {
        n2 = WindowsKeyboard.translateExtended(n2, n3, bl2);
        if (!bl3 && WindowsKeyboard.isKeyPressed(by2) == WindowsKeyboard.isKeyPressed(this.virt_key_down_buffer[n2])) {
            return;
        }
        this.flushRetained();
        this.has_retained_event = true;
        int n4 = WindowsKeycodes.mapVirtualKeyToLWJGLCode(n2);
        if (n4 < this.key_down_buffer.length) {
            this.key_down_buffer[n4] = by2;
            bl3 &= WindowsKeyboard.isKeyPressed(this.virt_key_down_buffer[n2]);
            this.virt_key_down_buffer[n2] = by2;
        }
        this.retained_key_code = n4;
        this.retained_state = by2;
        this.retained_millis = l2;
        this.retained_char = 0;
        this.retained_repeat = bl3;
    }

    void handleChar(int n2, long l2, boolean bl2) {
        if (this.has_retained_event && this.retained_char != 0) {
            this.flushRetained();
        }
        if (!this.has_retained_event) {
            this.putEvent(0, (byte)0, n2, l2, bl2);
        } else {
            this.retained_char = n2;
        }
    }

    void read(ByteBuffer byteBuffer) {
        this.flushRetained();
        this.event_queue.copyEvents(byteBuffer);
    }
}

